/*
 * Decompiled with CFR 0.152.
 */
package org.molap.exporter.parquet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.OutputFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;
import org.molap.exporter.parquet.DataFrameParquetWriter;
import org.molap.exporter.parquet.ParquetOutputFile;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010\u001b\u001a\u00020\u001a2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001dJ4\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00142\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001dH\u0002J \u0010\u001f\u001a\u00020\u001a2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001dR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R.\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lorg/molap/exporter/parquet/ParquetDataFrameExporter;", "R", "C", "V", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "Lorg/apache/parquet/io/OutputFile;", "compressionCodecName", "Lorg/apache/parquet/hadoop/metadata/CompressionCodecName;", "(Lorg/apache/parquet/io/OutputFile;Lorg/apache/parquet/hadoop/metadata/CompressionCodecName;)V", "getCompressionCodecName", "()Lorg/apache/parquet/hadoop/metadata/CompressionCodecName;", "getFile", "()Lorg/apache/parquet/io/OutputFile;", "parquetWriter", "Lorg/molap/exporter/parquet/DataFrameParquetWriter;", "getParquetWriter", "()Lorg/molap/exporter/parquet/DataFrameParquetWriter;", "setParquetWriter", "(Lorg/molap/exporter/parquet/DataFrameParquetWriter;)V", "close", "", "exportParquet", "df", "Lorg/molap/dataframe/DataFrame;", "init", "write", "molap-parquet"})
public final class ParquetDataFrameExporter<R, C, V> {
    @Nullable
    private DataFrameParquetWriter<R, C, V> parquetWriter;
    @NotNull
    private final OutputFile file;
    @NotNull
    private final CompressionCodecName compressionCodecName;

    @Nullable
    public final DataFrameParquetWriter<R, C, V> getParquetWriter() {
        return this.parquetWriter;
    }

    public final void setParquetWriter(@Nullable DataFrameParquetWriter<R, C, V> dataFrameParquetWriter) {
        this.parquetWriter = dataFrameParquetWriter;
    }

    public final void exportParquet(@NotNull DataFrame<R, C, V> df) throws IOException {
        Intrinsics.checkNotNullParameter(df, (String)"df");
        this.write(df);
        this.close();
    }

    private final DataFrameParquetWriter<R, C, V> init(DataFrame<R, C, V> df) throws IOException {
        ParquetWriter parquetWriter;
        String string = "Initializing " + this.file;
        boolean bl = false;
        System.out.println((Object)string);
        int pageSize = 65536;
        ParquetWriter parquetWriter2 = parquetWriter = ((DataFrameParquetWriter.Builder)((DataFrameParquetWriter.Builder)((DataFrameParquetWriter.Builder)DataFrameParquetWriter.Companion.builder(this.file).withSchema(df).withCompressionCodec(this.compressionCodecName)).withPageSize(pageSize)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();
        if (parquetWriter2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.molap.exporter.parquet.DataFrameParquetWriter<R, C, V>");
        }
        return (DataFrameParquetWriter)parquetWriter2;
    }

    public final void write(@NotNull DataFrame<R, C, V> df) throws IOException {
        Intrinsics.checkNotNullParameter(df, (String)"df");
        if (this.parquetWriter == null) {
            this.parquetWriter = this.init(df);
        }
        for (Object row : df.rows()) {
            DataFrameParquetWriter<R, C, V> dataFrameParquetWriter = this.parquetWriter;
            Intrinsics.checkNotNull(dataFrameParquetWriter);
            dataFrameParquetWriter.write(row);
        }
    }

    public final void close() throws IOException {
        DataFrameParquetWriter<R, C, V> dataFrameParquetWriter = this.parquetWriter;
        Intrinsics.checkNotNull(dataFrameParquetWriter);
        dataFrameParquetWriter.close();
    }

    @NotNull
    public final OutputFile getFile() {
        return this.file;
    }

    @NotNull
    public final CompressionCodecName getCompressionCodecName() {
        return this.compressionCodecName;
    }

    public ParquetDataFrameExporter(@NotNull OutputFile file, @NotNull CompressionCodecName compressionCodecName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)compressionCodecName, (String)"compressionCodecName");
        this.file = file;
        this.compressionCodecName = compressionCodecName;
    }

    public /* synthetic */ ParquetDataFrameExporter(OutputFile outputFile, CompressionCodecName compressionCodecName, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            compressionCodecName = CompressionCodecName.UNCOMPRESSED;
        }
        this(outputFile, compressionCodecName);
    }

    public ParquetDataFrameExporter(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        HadoopOutputFile hadoopOutputFile = HadoopOutputFile.fromPath((Path)new Path(file.toString()), (Configuration)new Configuration());
        Intrinsics.checkNotNullExpressionValue((Object)hadoopOutputFile, (String)"HadoopOutputFile.fromPat\u2026ring()), Configuration())");
        this((OutputFile)hadoopOutputFile, null, 2, null);
    }

    public ParquetDataFrameExporter(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this(new ParquetOutputFile(outputStream), null, 2, null);
    }
}

