/*
 * Decompiled with CFR 0.152.
 */
package org.molap.exporter.parquet;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J2\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t\"\u0004\b\u0002\u0010\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\fJI\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t\"\u0004\b\u0002\u0010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\f2\u0006\u0010\u0011\u001a\u0002H\tH\u0002\u00a2\u0006\u0002\u0010\u0012JQ\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t\"\u0004\b\u0002\u0010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\f2\u0006\u0010\u0011\u001a\u0002H\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015JA\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t\"\u0004\b\u0002\u0010\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\f2\u0006\u0010\u0016\u001a\u0002H\tH\u0002\u00a2\u0006\u0002\u0010\u0017J:\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t\"\u0004\b\u0002\u0010\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\fH\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/molap/exporter/parquet/DataFrameSchemaConverter;", "", "()V", "conf", "Lorg/apache/hadoop/conf/Configuration;", "(Lorg/apache/hadoop/conf/Configuration;)V", "convert", "Lorg/apache/parquet/schema/MessageType;", "R", "C", "V", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "convertField", "Lorg/apache/parquet/schema/Type;", "fieldName", "", "column", "(Ljava/lang/String;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;)Lorg/apache/parquet/schema/Type;", "repetition", "Lorg/apache/parquet/schema/Type$Repetition;", "(Ljava/lang/String;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Lorg/apache/parquet/schema/Type$Repetition;)Lorg/apache/parquet/schema/Type;", "field", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;)Lorg/apache/parquet/schema/Type;", "convertFields", "", "isElementType", "", "repeatedType", "parentName", "Companion", "molap-parquet"})
public final class DataFrameSchemaConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final boolean ADD_LIST_ELEMENT_RECORDS_DEFAULT = true;

    public DataFrameSchemaConverter() {
    }

    public DataFrameSchemaConverter(@Nullable Configuration conf) {
    }

    @NotNull
    public final <R, C, V> MessageType convert(@NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        return new MessageType(dataFrame.toString(), this.convertFields(dataFrame));
    }

    private final <R, C, V> List<Type> convertFields(DataFrame<R, C, V> dataFrame) {
        List types = new ArrayList();
        for (Object field : dataFrame.columns()) {
            types.add(this.convertField(dataFrame, field));
        }
        return types;
    }

    private final <R, C, V> Type convertField(String fieldName, DataFrame<R, C, V> dataFrame, C column) {
        return this.convertField(fieldName, dataFrame, column, Type.Repetition.OPTIONAL);
    }

    private final <R, C, V> Type convertField(String fieldName, DataFrame<R, C, V> dataFrame, C column, Type.Repetition repetition) {
        Types.PrimitiveBuilder primitiveBuilder;
        Object object;
        Types.PrimitiveBuilder builder = null;
        KClass type = dataFrame.getColumnClass(column);
        if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            object = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            Types.primitive(PrimitiveTypeName.BOOLEAN, repetition)\n        }");
            primitiveBuilder = object;
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            object = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            Types.primitive(PrimitiveTypeName.INT32, repetition)\n        }");
            primitiveBuilder = object;
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            object = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            Types.primitive(PrimitiveTypeName.INT64, repetition)\n        }");
            primitiveBuilder = object;
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            object = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            Types.primitive(PrimitiveTypeName.FLOAT, repetition)\n        }");
            primitiveBuilder = object;
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            object = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            Types.primitive(PrimitiveTypeName.DOUBLE, repetition)\n        }");
            primitiveBuilder = object;
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
            object = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            Types.primitive(PrimitiveTypeName.BINARY, repetition)\n        }");
            primitiveBuilder = object;
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            object = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            Types.primitive(PrimitiveTypeName.BINARY, repetition)\n                .`as`(LogicalTypeAnnotation.stringType())\n            //        } else if (type.equals(Object.class)) {\n//            return new GroupType(repetition, fieldName, convertFields(schema.getFields()));\n        }");
            primitiveBuilder = object;
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Enum.class))) {
            object = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            Types.primitive(PrimitiveTypeName.BINARY, repetition)\n                .`as`(LogicalTypeAnnotation.enumType())\n        }");
            primitiveBuilder = object;
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(URL.class))) {
            object = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            Types.primitive(PrimitiveTypeName.BINARY, repetition)\n                .`as`(LogicalTypeAnnotation.stringType())\n            //        } else if (type.equals(Object[].class)) {\n//            if (writeOldListStructure) {\n//                return ConversionPatterns.listType(repetition, fieldName,\n//                        convertField(\"array\", schema.getElementType(), REPEATED));\n//            } else {\n//                return ConversionPatterns.listOfElements(repetition, fieldName,\n//                        convertField(DataFrameWriteSupport.LIST_ELEMENT_NAME, schema.getElementType()));\n//            }\n//        } else if (type.equals(Schema.Type.MAP)) {\n//            Type valType = convertField(\"value\", schema.getValueType());\n////             map key type is always string\n//            return ConversionPatterns.stringKeyMapType(repetition, fieldName, valType);\n//        } else if (type.equals(Schema.Type.FIXED)) {\n//            builder = Types.primitive(FIXED_LEN_BYTE_ARRAY, repetition)\n//                    .length(schema.getFixedSize());\n//        } else if (type.equals(Schema.Type.UNION)) {\n//            return convertUnion(fieldName, schema, repetition);\n        }");
            primitiveBuilder = object;
        } else {
            throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Cannot convert type ", (Object)type));
        }
        builder = primitiveBuilder;
        object = builder.named(fieldName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.named(fieldName)");
        return (Type)object;
    }

    private final <R, C, V> Type convertField(DataFrame<R, C, V> dataFrame, C field) {
        String string = dataFrame.getColumnName(field);
        Intrinsics.checkNotNull((Object)string);
        return this.convertField(string, dataFrame, field);
    }

    private final boolean isElementType(Type repeatedType, String parentName) {
        return repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1 || repeatedType.asGroupType().getType(0).isRepetition(Type.Repetition.REPEATED) || Intrinsics.areEqual((Object)repeatedType.getName(), (Object)"array") || Intrinsics.areEqual((Object)repeatedType.getName(), (Object)Intrinsics.stringPlus((String)parentName, (Object)"_tuple"));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/molap/exporter/parquet/DataFrameSchemaConverter$Companion;", "", "()V", "ADD_LIST_ELEMENT_RECORDS_DEFAULT", "", "molap-parquet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

