package org.molap.parquet

import org.apache.parquet.io.DelegatingSeekableInputStream
import org.apache.parquet.io.InputFile
import org.apache.parquet.io.SeekableInputStream
import java.io.ByteArrayInputStream
import java.io.ByteArrayOutputStream
import java.io.IOException

class ParquetStream(private val streamId: String, stream: ByteArrayOutputStream) : InputFile {
    private val data: ByteArray = stream.toByteArray()

    inner class SeekableByteArrayInputStream(buf: ByteArray?) : ByteArrayInputStream(buf) {
        var pos: Int
            get() = super.pos
            set(pos) {
                super.pos = pos
            }
    }

    @Throws(IOException::class)
    override fun getLength(): Long {
        return data.size.toLong()
    }

    @Throws(IOException::class)
    override fun newStream(): SeekableInputStream {
        return object : DelegatingSeekableInputStream(SeekableByteArrayInputStream(this.data)) {
            @Throws(IOException::class)
            override fun seek(newPos: Long) {
                (stream as SeekableByteArrayInputStream).pos =
                    newPos.toInt()
            }

            @Throws(IOException::class)
            override fun getPos(): Long {
                return (stream as SeekableByteArrayInputStream).pos.toLong()
            }
        }
    }

    override fun toString(): String {
        return StringBuilder("ParquetStream[").append(streamId).append("]").toString()
    }
}