/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.parquet

import java.io.IOException
import java.io.OutputStream

class PositionOutputStream : org.apache.parquet.io.PositionOutputStream, Comparable<PositionOutputStream?> {
    private var position: Long = 0
    private val outputStream: OutputStream?

    constructor(outputStream: OutputStream?) : super() {
        this.outputStream = outputStream
    }

    constructor(outputStream: OutputStream?, positionOffset: Long) : super() {
        this.outputStream = outputStream
        position = positionOffset
    }

    @Throws(IOException::class)
    override fun write(b: Int) {
        outputStream!!.write(b)
        position++
    }

    @Throws(IOException::class)
    override fun write(b: ByteArray) {
        outputStream!!.write(b)
        position += b.size.toLong()
    }

    @Throws(IOException::class)
    override fun write(b: ByteArray, off: Int, len: Int) {
        outputStream!!.write(b, off, len)
        position += len.toLong()
    }

    @Throws(IOException::class)
    override fun getPos(): Long {
        return position
    }

    @Throws(IOException::class)
    override fun flush() {
        outputStream!!.flush()
    }

    @Throws(IOException::class)
    override fun close() {
        outputStream!!.close()
    }

    override fun hashCode(): Int {
        val prime = 31
        var result = 1
        result = prime * result + (outputStream?.hashCode() ?: 0)
        result = prime * result + (position xor (position ushr 32)).toInt()
        return result
    }

    override fun equals(obj: Any?): Boolean {
        if (this === obj) return true
        if (obj == null) return false
        if (javaClass != obj.javaClass) return false
        val other: PositionOutputStream = obj as PositionOutputStream
        if (outputStream == null) {
            if (other.outputStream != null) return false
        } else if (outputStream != other.outputStream) return false
        return if (position != other.position) false else true
    }

    override fun compareTo(other: PositionOutputStream?): Int {
        return java.lang.Long.compare(position, other!!.position)
    }
}