package org.molap.parquet

import kotlinx.io.Sink
import kotlinx.io.asOutputStream
import org.apache.parquet.hadoop.metadata.CompressionCodecName
import org.molap.dataframe.DataFrame
import java.io.File
import java.io.OutputStream

fun <R,C,V> DataFrame<R,C,V>.writeParquet(sink: Sink) {
    val outputStream = sink.asOutputStream()
    writeParquet(outputStream)
    sink.flush()
}

fun <R,C,V> DataFrame<R,C,V>.writeParquet(file: File) {
    val outputStream = file.outputStream()
    writeParquet(outputStream)
    outputStream.flush()
    outputStream.close()
}

fun <R,C,V> DataFrame<R,C,V>.writeParquet(outputStream: OutputStream, compressionCodecName: CompressionCodecName = CompressionCodecName.SNAPPY) {
    ParquetDataFrameExporter<R,C,V>(outputStream, compressionCodecName).exportParquet(this)
}