/*
 * Decompiled with CFR 0.152.
 */
package org.molap.parquet;

import com.macrofocus.common.units.Quantity;
import java.net.URL;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.datetime.Instant;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.molap.dataframe.DataFrame;
import org.molap.datetime.DateTimeTz;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J2\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n\"\u0004\b\u0002\u0010\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\rJ:\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n\"\u0004\b\u0002\u0010\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\rH\u0002JI\u0010\u0011\u001a\u00020\u0010\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n\"\u0004\b\u0002\u0010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u0014\u001a\u0002H\nH\u0002\u00a2\u0006\u0002\u0010\u0015JQ\u0010\u0011\u001a\u00020\u0010\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n\"\u0004\b\u0002\u0010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u0014\u001a\u0002H\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018JA\u0010\u0011\u001a\u00020\u0010\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n\"\u0004\b\u0002\u0010\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u0019\u001a\u0002H\nH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0013H\u0002\u00a8\u0006 "}, d2={"Lorg/molap/parquet/DataFrameSchemaConverter;", "", "<init>", "()V", "conf", "Lorg/apache/hadoop/conf/Configuration;", "(Lorg/apache/hadoop/conf/Configuration;)V", "convert", "Lorg/apache/parquet/schema/MessageType;", "R", "C", "V", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "convertFields", "", "Lorg/apache/parquet/schema/Type;", "convertField", "fieldName", "", "column", "(Ljava/lang/String;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;)Lorg/apache/parquet/schema/Type;", "repetition", "Lorg/apache/parquet/schema/Type$Repetition;", "(Ljava/lang/String;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Lorg/apache/parquet/schema/Type$Repetition;)Lorg/apache/parquet/schema/Type;", "field", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;)Lorg/apache/parquet/schema/Type;", "isElementType", "", "repeatedType", "parentName", "Companion", "molap-parquet"})
public final class DataFrameSchemaConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final boolean ADD_LIST_ELEMENT_RECORDS_DEFAULT = true;

    public DataFrameSchemaConverter() {
    }

    public DataFrameSchemaConverter(@Nullable Configuration conf) {
    }

    @NotNull
    public final <R, C, V> MessageType convert(@NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        return new MessageType(Reflection.getOrCreateKotlinClass(dataFrame.getClass()).getSimpleName(), this.convertFields(dataFrame));
    }

    private final <R, C, V> List<Type> convertFields(DataFrame<R, C, V> dataFrame) {
        List types = new ArrayList();
        for (Object field : dataFrame.columns()) {
            types.add(this.convertField(dataFrame, field));
        }
        return types;
    }

    private final <R, C, V> Type convertField(String fieldName, DataFrame<R, C, V> dataFrame, C column) {
        return this.convertField(fieldName, dataFrame, column, Type.Repetition.OPTIONAL);
    }

    private final <R, C, V> Type convertField(String fieldName, DataFrame<R, C, V> dataFrame, C column, Type.Repetition repetition) {
        Types.PrimitiveBuilder primitiveBuilder;
        Types.PrimitiveBuilder builder = null;
        KClass type = dataFrame.getColumnClass(column);
        if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            primitiveBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition);
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            primitiveBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition);
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            primitiveBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition);
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            primitiveBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition);
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            primitiveBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition);
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Quantity.class))) {
            primitiveBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition);
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
            primitiveBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            primitiveBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(DateTimeTz.class))) {
            primitiveBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
            primitiveBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class))) {
            primitiveBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Timestamp.class))) {
            primitiveBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Enum.class))) {
            primitiveBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType());
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(URL.class))) {
            primitiveBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        } else if (Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Geometry.class)) || Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Point.class)) || Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(LineString.class)) || Intrinsics.areEqual((Object)type, (Object)Reflection.getOrCreateKotlinClass(Polygon.class))) {
            primitiveBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        } else {
            throw new UnsupportedOperationException("Cannot convert type " + type + " for field " + fieldName);
        }
        Types.PrimitiveBuilder primitiveBuilder2 = primitiveBuilder;
        Intrinsics.checkNotNull((Object)primitiveBuilder2);
        builder = primitiveBuilder2;
        Object object = builder.named(fieldName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"named(...)");
        return (Type)object;
    }

    private final <R, C, V> Type convertField(DataFrame<R, C, V> dataFrame, C field) {
        String string = dataFrame.getColumnName(field);
        Intrinsics.checkNotNull((Object)string);
        return this.convertField(string, dataFrame, field);
    }

    private final boolean isElementType(Type repeatedType, String parentName) {
        return repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1 || repeatedType.asGroupType().getType(0).isRepetition(Type.Repetition.REPEATED) || Intrinsics.areEqual((Object)repeatedType.getName(), (Object)"array") || Intrinsics.areEqual((Object)repeatedType.getName(), (Object)(parentName + "_tuple"));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/molap/parquet/DataFrameSchemaConverter$Companion;", "", "<init>", "()V", "ADD_LIST_ELEMENT_RECORDS_DEFAULT", "", "molap-parquet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

