/*
 * Decompiled with CFR 0.152.
 */
package org.molap.parquet;

import com.macrofocus.common.units.Quantity;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.datetime.Instant;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.Preconditions;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTWriter;
import org.molap.dataframe.DataFrame;
import org.molap.datetime.DateTimeTz;
import org.molap.parquet.DataFrameSchemaConverter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ,*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0002+,B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0017\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ7\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u001c2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\n2\u0006\u0010\u0019\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001dJK\u0010\u001e\u001a\u00020\u0017\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u001c2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n2\u0006\u0010\u0019\u001a\u0002H\u0001H\u0002\u00a2\u0006\u0002\u0010\u001dJS\u0010\u001f\u001a\u00020\u0017\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\b\u0010 \u001a\u0004\u0018\u00010!2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n2\u0006\u0010\"\u001a\u0002H\u00022\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010%JS\u0010&\u001a\u00020\u0017\"\u0004\b\u0003\u0010\u0001\"\u0004\b\u0004\u0010\u0002\"\u0004\b\u0005\u0010\u00032\b\u0010 \u001a\u0004\u0018\u00010!2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\n2\u0006\u0010\"\u001a\u0002H\u00022\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010(2\u0006\u0010#\u001a\u00020$H\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/molap/parquet/DataFrameWriteSupport;", "R", "C", "V", "Lorg/apache/parquet/hadoop/api/WriteSupport;", "<init>", "()V", "schema", "Lorg/apache/parquet/schema/MessageType;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "(Lorg/apache/parquet/schema/MessageType;Lorg/molap/dataframe/DataFrame;)V", "recordConsumer", "Lorg/apache/parquet/io/api/RecordConsumer;", "rootSchema", "rootdataFrame", "getName", "", "init", "Lorg/apache/parquet/hadoop/api/WriteSupport$WriteContext;", "configuration", "Lorg/apache/hadoop/conf/Configuration;", "prepareForWrite", "", "write", "record", "(Ljava/lang/Object;)V", "writeRecord", "Lorg/apache/parquet/schema/GroupType;", "(Lorg/apache/parquet/schema/GroupType;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;)V", "writeRecordFields", "writeValue", "type", "Lorg/apache/parquet/schema/Type;", "column", "value", "", "(Lorg/apache/parquet/schema/Type;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/lang/Object;)V", "writeValueWithoutConversion", "fromString", "Lorg/apache/parquet/io/api/Binary;", "fromURL", "fromGeometry", "ListWriter", "Companion", "molap-parquet"})
public final class DataFrameWriteSupport<R, C, V>
extends WriteSupport<R> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private RecordConsumer recordConsumer;
    @Nullable
    private MessageType rootSchema;
    @Nullable
    private DataFrame<R, C, V> rootdataFrame;
    @NotNull
    private static final String MAP_REPEATED_NAME = "key_value";
    @NotNull
    private static final String MAP_KEY_NAME = "key";
    @NotNull
    private static final String MAP_VALUE_NAME = "value";
    @NotNull
    private static final String LIST_REPEATED_NAME = "list";
    @NotNull
    private static final String OLD_LIST_REPEATED_NAME = "array";
    @NotNull
    public static final String LIST_ELEMENT_NAME = "element";

    public DataFrameWriteSupport() {
    }

    @Deprecated(message="will be removed in 2.0.0")
    public DataFrameWriteSupport(@Nullable MessageType schema, @Nullable DataFrame<R, C, V> dataFrame) {
        this.rootSchema = schema;
        this.rootdataFrame = dataFrame;
    }

    @NotNull
    public String getName() {
        return "avro";
    }

    @NotNull
    public WriteSupport.WriteContext init(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (this.rootdataFrame == null) {
            DataFrameSchemaConverter dataFrameSchemaConverter = new DataFrameSchemaConverter();
            DataFrame<R, C, V> dataFrame = this.rootdataFrame;
            Intrinsics.checkNotNull(dataFrame);
            this.rootSchema = dataFrameSchemaConverter.convert(dataFrame);
        }
        Map extraMetaData = new HashMap();
        return new WriteSupport.WriteContext(this.rootSchema, extraMetaData);
    }

    public void prepareForWrite(@NotNull RecordConsumer recordConsumer) {
        Intrinsics.checkNotNullParameter((Object)recordConsumer, (String)"recordConsumer");
        this.recordConsumer = recordConsumer;
    }

    public void write(R record) {
        RecordConsumer recordConsumer = this.recordConsumer;
        Intrinsics.checkNotNull((Object)recordConsumer);
        recordConsumer.startMessage();
        GroupType groupType = (GroupType)this.rootSchema;
        DataFrame<R, C, V> dataFrame = this.rootdataFrame;
        Intrinsics.checkNotNull(dataFrame);
        this.writeRecordFields(groupType, dataFrame, record);
        RecordConsumer recordConsumer2 = this.recordConsumer;
        Intrinsics.checkNotNull((Object)recordConsumer2);
        recordConsumer2.endMessage();
    }

    private final void writeRecord(GroupType schema, DataFrame<R, C, V> dataFrame, R record) {
        RecordConsumer recordConsumer = this.recordConsumer;
        Intrinsics.checkNotNull((Object)recordConsumer);
        recordConsumer.startGroup();
        this.writeRecordFields(schema, dataFrame, record);
        RecordConsumer recordConsumer2 = this.recordConsumer;
        Intrinsics.checkNotNull((Object)recordConsumer2);
        recordConsumer2.endGroup();
    }

    private final <R, C, V> void writeRecordFields(GroupType schema, DataFrame<R, C, V> dataFrame, R record) {
        GroupType groupType = schema;
        Intrinsics.checkNotNull((Object)groupType);
        List fields = groupType.getFields();
        int index = 0;
        for (Object column : dataFrame.columns()) {
            Type fieldType = (Type)fields.get(index);
            Object value = dataFrame.getValueAt(record, column);
            if (value != null) {
                String columnName = dataFrame.getColumnName(column);
                RecordConsumer recordConsumer = this.recordConsumer;
                Intrinsics.checkNotNull((Object)recordConsumer);
                recordConsumer.startField(columnName, index);
                this.writeValue(null, dataFrame, column, value);
                RecordConsumer recordConsumer2 = this.recordConsumer;
                Intrinsics.checkNotNull((Object)recordConsumer2);
                recordConsumer2.endField(columnName, index);
            } else if (fieldType.isRepetition(Type.Repetition.REQUIRED)) {
                throw new RuntimeException("Null-value for required field: " + column);
            }
            ++index;
        }
    }

    private final <R, C, V> void writeValue(Type type, DataFrame<R, C, V> dataFrame, C column, Object value) {
        this.writeValueWithoutConversion(type, dataFrame, column, value);
    }

    private final <R, C, V> void writeValueWithoutConversion(Type type, DataFrame<R, C, V> dataFrame, C column, Object value) {
        KClass columnClass = dataFrame.getColumnClass(column);
        if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            recordConsumer.addBoolean(((Boolean)value).booleanValue());
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Integer.TYPE), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Number");
            recordConsumer.addInteger(((Number)value).intValue());
        } else if (value instanceof Character) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addInteger((int)((Character)value).charValue());
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Long.TYPE), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Number");
            recordConsumer.addLong(((Number)value).longValue());
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Float.TYPE), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Number");
            recordConsumer.addFloat(((Number)value).floatValue());
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Double.TYPE), (Object)columnClass)) {
            if (!(value instanceof Number)) {
                System.out.println((Object)("Column " + column + " has value " + value + " of type " + Reflection.getOrCreateKotlinClass(value.getClass()) + " instead of Number"));
                throw new ClassCastException("Column " + column + " has value " + value + " of type " + Reflection.getOrCreateKotlinClass(value.getClass()) + " instead of Number");
            }
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addDouble(((Number)value).doubleValue());
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Quantity.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.macrofocus.common.units.Quantity<*>");
            recordConsumer.addDouble(((Quantity)value).getAmount());
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(byte[].class), (Object)columnClass)) {
            if (value instanceof byte[]) {
                RecordConsumer recordConsumer = this.recordConsumer;
                Intrinsics.checkNotNull((Object)recordConsumer);
                recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])((byte[])value)));
            } else {
                RecordConsumer recordConsumer = this.recordConsumer;
                Intrinsics.checkNotNull((Object)recordConsumer);
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type java.nio.ByteBuffer");
                recordConsumer.addBinary(Binary.fromReusedByteBuffer((ByteBuffer)((ByteBuffer)value)));
            }
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(DateTimeTz.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.molap.datetime.DateTimeTz");
            recordConsumer.addLong(((DateTimeTz)value).getDatetime().toEpochMilliseconds());
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Instant.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlinx.datetime.Instant");
            recordConsumer.addLong(((Instant)value).toEpochMilliseconds());
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type java.time.LocalDateTime");
            recordConsumer.addLong(((LocalDateTime)value).toEpochSecond(ZoneOffset.UTC) * (long)1000);
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Timestamp.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type java.sql.Timestamp");
            recordConsumer.addLong(((Timestamp)value).getTime());
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(String.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addBinary(this.fromString(value));
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Enum.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addBinary(Binary.fromString((String)value.toString()));
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(URL.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addBinary(this.fromURL(value));
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Geometry.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addBinary(this.fromGeometry(value));
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Point.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addBinary(this.fromGeometry(value));
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(LineString.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addBinary(this.fromGeometry(value));
        } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(Polygon.class), (Object)columnClass)) {
            RecordConsumer recordConsumer = this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.addBinary(this.fromGeometry(value));
        } else {
            System.out.println((Object)("Unknown column class " + columnClass + " for " + column + " and value " + value));
        }
    }

    private final Binary fromString(Object value) {
        Binary binary;
        if (value instanceof CharSequence) {
            Binary binary2 = Binary.fromCharSequence((CharSequence)((CharSequence)value));
            Intrinsics.checkNotNull((Object)binary2);
            binary = binary2;
        } else {
            Binary binary3 = Binary.fromCharSequence((CharSequence)value.toString());
            binary = binary3;
            Intrinsics.checkNotNullExpressionValue((Object)binary3, (String)"fromCharSequence(...)");
        }
        return binary;
    }

    private final Binary fromURL(Object value) {
        return value instanceof URL ? Binary.fromCharSequence((CharSequence)((URL)value).toExternalForm()) : null;
    }

    private final Binary fromGeometry(Object value) {
        return value instanceof Geometry ? Binary.fromCharSequence((CharSequence)new WKTWriter(0, 1, null).write((Geometry)value)) : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/molap/parquet/DataFrameWriteSupport$Companion;", "", "<init>", "()V", "MAP_REPEATED_NAME", "", "MAP_KEY_NAME", "MAP_VALUE_NAME", "LIST_REPEATED_NAME", "OLD_LIST_REPEATED_NAME", "LIST_ELEMENT_NAME", "molap-parquet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0013\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH$JC\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t2\u0010\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u000eH$\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0005H$J\b\u0010\u0011\u001a\u00020\u0005H$J2\u0010\u0012\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0001J>\u0010\u0015\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0014\u001a\u00020\u0001J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0019H\u0004J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u001bH\u0004J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u001dH\u0004J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u001fH\u0004J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\r\u001a\u00020!H\u0004J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020#H\u0004J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020%H\u0004J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020'H\u0004\u00a8\u0006("}, d2={"Lorg/molap/parquet/DataFrameWriteSupport$ListWriter;", "", "<init>", "(Lorg/molap/parquet/DataFrameWriteSupport;)V", "writeCollection", "", "type", "Lorg/apache/parquet/schema/GroupType;", "schema", "Lorg/molap/dataframe/DataFrame;", "collection", "", "writeObjectArray", "array", "", "(Lorg/apache/parquet/schema/GroupType;Lorg/molap/dataframe/DataFrame;[Ljava/lang/Object;)V", "startArray", "endArray", "writeList", "dataFrame", "value", "writeJavaArray", "arrayClass", "Ljava/lang/Class;", "writeBooleanArray", "", "writeByteArray", "", "writeShortArray", "", "writeCharArray", "", "writeIntArray", "", "writeLongArray", "", "writeFloatArray", "", "writeDoubleArray", "", "molap-parquet"})
    private abstract class ListWriter {
        protected abstract void writeCollection(@Nullable GroupType var1, @NotNull DataFrame<R, C, V> var2, @Nullable Collection<?> var3);

        protected abstract void writeObjectArray(@Nullable GroupType var1, @NotNull DataFrame<R, C, V> var2, @Nullable Object[] var3);

        protected abstract void startArray();

        protected abstract void endArray();

        public final void writeList(@Nullable GroupType schema, @NotNull DataFrame<R, C, V> dataFrame, @NotNull Object value) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            Intrinsics.checkNotNullParameter((Object)value, (String)DataFrameWriteSupport.MAP_VALUE_NAME);
            RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer);
            recordConsumer.startGroup();
            if (value instanceof Collection) {
                this.writeCollection(schema, dataFrame, (Collection)value);
            } else {
                Class<?> arrayClass = value.getClass();
                Preconditions.checkArgument((boolean)arrayClass.isArray(), (String)("Cannot write unless collection or array: " + arrayClass.getName()));
                this.writeJavaArray(schema, dataFrame, arrayClass, value);
            }
            RecordConsumer recordConsumer2 = DataFrameWriteSupport.this.recordConsumer;
            Intrinsics.checkNotNull((Object)recordConsumer2);
            recordConsumer2.endGroup();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void writeJavaArray(@Nullable GroupType schema, @NotNull DataFrame<R, C, V> dataFrame, @NotNull Class<?> arrayClass, @NotNull Object value) {
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            Intrinsics.checkNotNullParameter(arrayClass, (String)"arrayClass");
            Intrinsics.checkNotNullParameter((Object)value, (String)DataFrameWriteSupport.MAP_VALUE_NAME);
            Class<?> elementClass = arrayClass.getComponentType();
            if (!elementClass.isPrimitive()) {
                this.writeObjectArray(schema, dataFrame, (Object[])value);
                return;
            }
            KClass columnClass = dataFrame.getColumnClass(null);
            if (Intrinsics.areEqual(Boolean.TYPE, (Object)columnClass)) {
                Preconditions.checkArgument((boolean)Intrinsics.areEqual(elementClass, Boolean.TYPE), (String)("Cannot write as boolean array: " + arrayClass.getName()));
                this.writeBooleanArray((boolean[])value);
                return;
            } else if (Intrinsics.areEqual(Integer.TYPE, (Object)columnClass)) {
                if (Intrinsics.areEqual(elementClass, Byte.TYPE)) {
                    this.writeByteArray((byte[])value);
                    return;
                } else if (Intrinsics.areEqual(elementClass, Character.TYPE)) {
                    this.writeCharArray((char[])value);
                    return;
                } else if (Intrinsics.areEqual(elementClass, Short.TYPE)) {
                    this.writeShortArray((short[])value);
                    return;
                } else {
                    if (!Intrinsics.areEqual(elementClass, Integer.TYPE)) throw new IllegalArgumentException("Cannot write as an int array: " + arrayClass.getName());
                    this.writeIntArray((int[])value);
                }
                return;
            } else if (Intrinsics.areEqual(Long.TYPE, (Object)columnClass)) {
                Preconditions.checkArgument((boolean)Intrinsics.areEqual(elementClass, Long.TYPE), (String)("Cannot write as long array: " + arrayClass.getName()));
                this.writeLongArray((long[])value);
                return;
            } else if (Intrinsics.areEqual(Float.TYPE, (Object)columnClass)) {
                Preconditions.checkArgument((boolean)Intrinsics.areEqual(elementClass, Float.TYPE), (String)("Cannot write as float array: " + arrayClass.getName()));
                this.writeFloatArray((float[])value);
                return;
            } else {
                if (!Intrinsics.areEqual(Double.TYPE, (Object)columnClass)) throw new IllegalArgumentException("Cannot write " + dataFrame.getColumnClass(null) + " array: " + arrayClass.getName());
                Preconditions.checkArgument((boolean)Intrinsics.areEqual(elementClass, Double.TYPE), (String)("Cannot write as double array: " + arrayClass.getName()));
                this.writeDoubleArray((double[])value);
            }
        }

        protected final void writeBooleanArray(@NotNull boolean[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (boolean element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addBoolean(element);
                }
                this.endArray();
            }
        }

        protected final void writeByteArray(@NotNull byte[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (byte element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected final void writeShortArray(@NotNull short[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (short element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected final void writeCharArray(@NotNull char[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (char element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addInteger((int)element);
                }
                this.endArray();
            }
        }

        protected final void writeIntArray(@NotNull int[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (int element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addInteger(element);
                }
                this.endArray();
            }
        }

        protected final void writeLongArray(@NotNull long[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (long element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addLong(element);
                }
                this.endArray();
            }
        }

        protected final void writeFloatArray(@NotNull float[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (float element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addFloat(element);
                }
                this.endArray();
            }
        }

        protected final void writeDoubleArray(@NotNull double[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)DataFrameWriteSupport.OLD_LIST_REPEATED_NAME);
            if (array.length > 0) {
                this.startArray();
                for (double element : array) {
                    RecordConsumer recordConsumer = DataFrameWriteSupport.this.recordConsumer;
                    Intrinsics.checkNotNull((Object)recordConsumer);
                    recordConsumer.addDouble(element);
                }
                this.endArray();
            }
        }
    }
}

