/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.parquet

import org.apache.hadoop.conf.Configuration
import org.apache.hadoop.fs.Path
import org.apache.parquet.hadoop.ParquetWriter
import org.apache.parquet.hadoop.api.WriteSupport
import org.apache.parquet.hadoop.metadata.CompressionCodecName
import org.apache.parquet.io.OutputFile
import org.molap.dataframe.DataFrame

/**
 * Write DataFrame records to a Parquet file.
 */
class DataFrameParquetWriter<R,C,V> : ParquetWriter<R> {
    /** Create a new [com.macrofocus.molap.exporter.parquet.DataFrameParquetWriter].
     *
     * @param file a file path
     * @param dataFrame a schema for the write
     * @param compressionCodecName compression codec
     * @param blockSize target block size
     * @param pageSize target page size
     * @throws IOException if there is an error while writing
     */
    @Deprecated("")
    constructor(
        file: Path?, dataFrame: DataFrame<R,C,V>,
        compressionCodecName: CompressionCodecName?, blockSize: Int,
        pageSize: Int
    ) : super(
        file, writeSupport(dataFrame),
        compressionCodecName, blockSize, pageSize
    ) {
    }

    /** Create a new [com.macrofocus.molap.exporter.parquet.DataFrameParquetWriter].
     *
     * @param file The file name to write to.
     * @param dataFrame The schema to write with.
     * @param compressionCodecName Compression code to use, or CompressionCodecName.UNCOMPRESSED
     * @param blockSize the block size threshold.
     * @param pageSize See parquet write up. Blocks are subdivided into pages for alignment and other purposes.
     * @param enableDictionary Whether to use a dictionary to compress columns.
     * @throws IOException if there is an error while writing
     */
    @Deprecated("")
    constructor(
        file: Path?, dataFrame: DataFrame<R,C,V> ,
        compressionCodecName: CompressionCodecName?, blockSize: Int,
        pageSize: Int, enableDictionary: Boolean
    ) : super(
        file, writeSupport<R,C,V>(dataFrame),
        compressionCodecName, blockSize, pageSize, enableDictionary,
        DEFAULT_IS_VALIDATING_ENABLED
    ) {
    }

    /** Create a new [com.macrofocus.molap.exporter.parquet.DataFrameParquetWriter]. The default block size is 50 MB.The default
     * page size is 1 MB.  Default compression is no compression. (Inherited from [ParquetWriter])
     *
     * @param file The file name to write to.
     * @param dataFrame The schema to write with.
     * @throws IOException if there is an error while writing
     */
    @Deprecated("")
    constructor(file: Path?, dataFrame: DataFrame<R,C,V>) : this(
        file, dataFrame, CompressionCodecName.UNCOMPRESSED,
        DEFAULT_BLOCK_SIZE, DEFAULT_PAGE_SIZE
    ) {
    }

    class Builder<R,C,V> : ParquetWriter.Builder<R, Builder<R, C, V>> {
        private var schema: DataFrame<R,C,V>? = null

        constructor(file: Path) : super(file) {}
        constructor(file: OutputFile) : super(file) {}

        fun withSchema(schema: DataFrame<R,C,V>?): Builder<R, C, V> {
            this.schema = schema
            return this
        }

        override fun self(): Builder<R, C, V> {
            return this
        }

        override fun getWriteSupport(conf: Configuration): WriteSupport<R> {
            return writeSupport(conf, schema!!)
        }
    }

    companion object {
        fun <R,C,V> builder(file: Path): Builder<R, C, V> {
            return Builder(file)
        }

        fun <R,C,V> builder(file: OutputFile): Builder<R, C, V> {
            return Builder(file)
        }

        private fun <R,C,V> writeSupport(dataFrame: DataFrame<R,C,V>): WriteSupport<R> {
            return DataFrameWriteSupport<R,C,V>(
                DataFrameSchemaConverter().convert(dataFrame), dataFrame
            )
        }

        private fun <R,C,V> writeSupport(
            conf: Configuration,
            dataFrame: DataFrame<R,C,V>
        ): WriteSupport<R> {
            return DataFrameWriteSupport<R,C,V>(
                DataFrameSchemaConverter(conf).convert(dataFrame), dataFrame
            )
        }
    }
}