package org.molap.parquet

import kotlinx.io.Source
import kotlinx.io.asInputStream
import org.molap.dataframe.DataFrame
import java.io.File
import java.io.InputStream

fun DataFrame.Companion.readParquet(source: Source): DataFrame<Int, String, Any?> {
    return readParquet(source.asInputStream())
}

fun DataFrame.Companion.readParquet(file: File): DataFrame<Int, String, Any?> {
    val inputStream = file.inputStream()
    val dataFrame = readParquet(inputStream)
    inputStream.close()
    return dataFrame
}

fun DataFrame.Companion.readParquet(inputStream: InputStream): DataFrame<Int, String, Any?> {
    return ParquetDataFrame(inputStream)
}