/*
 * Decompiled with CFR 0.152.
 */
package org.molap.parquet;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReadStore;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DefaultDataFrame;
import org.molap.dataframe.IndexedDataFrame;
import org.molap.index.UniqueIndex;
import org.molap.parquet.ParquetStream;
import org.molap.series.Series;
import org.molap.series.SeriesFactory;
import org.molap.series.SeriesOfKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J&\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006R'\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lorg/molap/parquet/ParquetDataFrame;", "Lorg/molap/dataframe/AbstractDataFrame;", "", "", "", "bis", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "df", "Lorg/molap/dataframe/DataFrame;", "getDf", "()Lorg/molap/dataframe/DataFrame;", "getRowClass", "Lkotlin/reflect/KClass;", "row", "getColumnClass", "column", "getValueAt", "rowIndex", "Lorg/molap/index/UniqueIndex;", "getRowIndex", "()Lorg/molap/index/UniqueIndex;", "columnIndex", "getColumnIndex", "loadDataFrameFromInputStream", "molap-parquet"})
@SourceDebugExtension(value={"SMAP\nParquetDataFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParquetDataFrame.kt\norg/molap/parquet/ParquetDataFrame\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,518:1\n1#2:519\n*E\n"})
public final class ParquetDataFrame
extends AbstractDataFrame<Integer, String, Object> {
    @Nullable
    private final DataFrame<Integer, String, Object> df;

    public ParquetDataFrame(@NotNull InputStream bis) {
        Intrinsics.checkNotNullParameter((Object)bis, (String)"bis");
        this.df = this.loadDataFrameFromInputStream(bis);
    }

    @Nullable
    public final DataFrame<Integer, String, Object> getDf() {
        return this.df;
    }

    @Nullable
    public KClass<?> getRowClass(int row) {
        DataFrame<Integer, String, Object> dataFrame = this.df;
        Intrinsics.checkNotNull(dataFrame);
        return dataFrame.getRowClass((Object)row);
    }

    @NotNull
    public KClass<?> getColumnClass(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        DataFrame<Integer, String, Object> dataFrame = this.df;
        Intrinsics.checkNotNull(dataFrame);
        return dataFrame.getColumnClass((Object)column);
    }

    @Nullable
    public Object getValueAt(int row, @NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        DataFrame<Integer, String, Object> dataFrame = this.df;
        Intrinsics.checkNotNull(dataFrame);
        return dataFrame.getValueAt((Object)row, (Object)column);
    }

    @NotNull
    public UniqueIndex<Integer> getRowIndex() {
        DataFrame<Integer, String, Object> dataFrame = this.df;
        Intrinsics.checkNotNull(dataFrame);
        return dataFrame.getRowIndex();
    }

    @NotNull
    public UniqueIndex<String> getColumnIndex() {
        DataFrame<Integer, String, Object> dataFrame = this.df;
        Intrinsics.checkNotNull(dataFrame);
        return dataFrame.getColumnIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DataFrame<Integer, String, Object> loadDataFrameFromInputStream(@Nullable InputStream bis) throws IOException, SQLException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        InputStream inputStream = bis;
        Intrinsics.checkNotNull((Object)inputStream);
        stream.write(inputStream.readAllBytes());
        Closeable closeable = (Closeable)ParquetFileReader.open((InputFile)new ParquetStream("parquet", stream));
        Throwable throwable = null;
        try {
            PageReadStore pageReadStore;
            ParquetFileReader reader = (ParquetFileReader)closeable;
            boolean bl = false;
            ParquetMetadata footer = reader.getFooter();
            MessageType schema = footer.getFileMetaData().getSchema();
            long nrows = reader.getRecordCount();
            PageReadStore store = null;
            PageReadStore it = pageReadStore = reader.readNextRowGroup();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            store = it;
            if (pageReadStore != null) {
                long rowCount = store.getRowCount();
                ColumnReadStore colReader = (ColumnReadStore)new ColumnReadStoreImpl(store, new GroupRecordConverter(schema).getRootConverter(), schema, footer.getFileMetaData().getCreatedBy());
                List columns = schema.getColumns();
                Object[] vectors = new Series[columns.size()];
                int n = ((Collection)columns).size();
                block66: for (int c = 0; c < n; ++c) {
                    ColumnDescriptor column = (ColumnDescriptor)columns.get(c);
                    Type.Repetition allowNull = column.getPrimitiveType().getRepetition();
                    PrimitiveType primitiveType = column.getPrimitiveType();
                    OriginalType originalType = primitiveType.getOriginalType();
                    String[] path = column.getPath();
                    String name = path[path.length - 1];
                    ColumnReader columnReader = colReader.getColumnReader(column);
                    int count = (int)columnReader.getTotalValueCount();
                    int maxDefinitionLevel = column.getMaxDefinitionLevel();
                    int rep = columnReader.getCurrentRepetitionLevel();
                    PrimitiveType.PrimitiveTypeName primitiveTypeName = primitiveType.getPrimitiveTypeName();
                    switch (primitiveTypeName == null ? -1 : WhenMappings.$EnumSwitchMapping$1[primitiveTypeName.ordinal()]) {
                        case 1: {
                            int i2;
                            if (rep >= 0 && rep <= 1) {
                                Object[] a = new Boolean[count];
                                for (i2 = 0; i2 < count; ++i2) {
                                    int definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        a[i2] = columnReader.getBoolean();
                                    }
                                    columnReader.consume();
                                }
                                Intrinsics.checkNotNull((Object)name);
                                Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                            } else if (rep > 1) {
                                boolean[] cfr_ignored_0 = new boolean[rep];
                            }
                            Unit unit = Unit.INSTANCE;
                            continue block66;
                        }
                        case 2: {
                            int scale;
                            DecimalMetadata decimalMetadata;
                            int definitionLevel;
                            int i;
                            Object[] a;
                            Unit unit;
                            OriginalType originalType2 = originalType;
                            switch (originalType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[originalType2.ordinal()]) {
                                case -1: {
                                    if (rep >= 0 && rep <= 1) {
                                        a = new Integer[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                a[i] = columnReader.getInteger();
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesOfKt.seriesOf((Object)name, (Object[])Arrays.copyOf(a, a.length)), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    } else if (rep > 1) {
                                        throw new NotImplementedError(null, 1, null);
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 1: {
                                    if (rep >= 0 && rep <= 1) {
                                        a = new Byte[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                a[i] = (byte)columnReader.getInteger();
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    } else if (rep > 1) {
                                        // empty if block
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 2: 
                                case 3: {
                                    if (rep >= 0 && rep <= 1) {
                                        a = new Short[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                a[i] = (short)columnReader.getInteger();
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    } else if (rep > 1) {
                                        // empty if block
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 4: 
                                case 5: {
                                    if (rep >= 0 && rep <= 1) {
                                        a = new Integer[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                a[i] = columnReader.getInteger();
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    } else if (rep > 1) {
                                        // empty if block
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 6: {
                                    if (rep >= 0 && rep <= 1) {
                                        a = new BigDecimal[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                int unscaledValue = columnReader.getInteger();
                                                decimalMetadata = primitiveType.getDecimalMetadata();
                                                scale = decimalMetadata.getScale();
                                                a[i] = BigDecimal.valueOf(unscaledValue, scale);
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 7: {
                                    if (rep >= 0 && rep <= 1) {
                                        a = new LocalDate[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                int days = columnReader.getInteger();
                                                a[i] = LocalDate.ofEpochDay(days);
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 8: {
                                    if (rep >= 0 && rep <= 1) {
                                        a = new LocalTime[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                int millis = columnReader.getInteger();
                                                a[i] = LocalTime.ofNanoOfDay(millis * 1000000);
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 9: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 10: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 11: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 12: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 13: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 14: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 15: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 16: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 17: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 18: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 19: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 20: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 21: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 22: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                        case 3: {
                            int definitionLevel;
                            int i;
                            Unit unit;
                            int i2;
                            if (originalType == null) {
                                if (rep >= 0 && rep <= 1) {
                                    Object[] a = new Long[count];
                                    for (i2 = 0; i2 < count; ++i2) {
                                        int definitionLevel2 = columnReader.getCurrentDefinitionLevel();
                                        if (definitionLevel2 == maxDefinitionLevel) {
                                            a[i2] = columnReader.getLong();
                                        }
                                        columnReader.consume();
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    }
                                } else if (rep > 1) {
                                    // empty if block
                                }
                            }
                            OriginalType originalType3 = originalType;
                            switch (originalType3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[originalType3.ordinal()]) {
                                case 19: {
                                    if (rep >= 0 && rep <= 1) {
                                        Object[] a = new Long[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                a[i] = columnReader.getLong();
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    } else if (rep > 1) {
                                        // empty if block
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 6: {
                                    if (rep >= 0 && rep <= 1) {
                                        Object[] a = new BigDecimal[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                long unscaledValue = columnReader.getLong();
                                                DecimalMetadata decimalMetadata = primitiveType.getDecimalMetadata();
                                                int scale = decimalMetadata.getScale();
                                                a[i] = BigDecimal.valueOf(unscaledValue, scale);
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 14: {
                                    long micros;
                                    if (rep >= 0 && rep <= 1) {
                                        Object[] a = new LocalTime[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                micros = columnReader.getLong();
                                                a[i] = LocalTime.ofNanoOfDay(micros * (long)1000);
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 15: {
                                    if (rep >= 0 && rep <= 1) {
                                        Object[] a = new LocalDateTime[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                long millis = columnReader.getLong();
                                                a[i] = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 16: {
                                    long micros;
                                    if (rep >= 0 && rep <= 1) {
                                        Object[] a = new LocalDateTime[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                micros = columnReader.getLong();
                                                long second = micros / (long)1000000;
                                                int nano = (int)(micros % (long)1000000) * 1000;
                                                a[i] = LocalDateTime.ofEpochSecond(second, nano, ZoneOffset.UTC);
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 9: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 10: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 11: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 12: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 13: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 7: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 8: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 2: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 4: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 17: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 18: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 1: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 3: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 5: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 20: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 21: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                                case 22: {
                                    throw new NotImplementedError(null, 1, null);
                                }
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                        case 4: {
                            int i2;
                            if (rep >= 0 && rep <= 1) {
                                Object[] a = new LocalDateTime[count];
                                for (i2 = 0; i2 < count; ++i2) {
                                    int definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        ByteBuffer buf = columnReader.getBinary().toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                                        long nanoOfDay = buf.getLong();
                                        int julianDay = buf.getInt();
                                        LocalDate date = LocalDate.ofEpochDay(julianDay - 2440588);
                                        LocalTime time = LocalTime.ofNanoOfDay(nanoOfDay);
                                        a[i2] = LocalDateTime.of(date, time);
                                    }
                                    columnReader.consume();
                                }
                                Intrinsics.checkNotNull((Object)name);
                                Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                            }
                            Unit unit = Unit.INSTANCE;
                            continue block66;
                        }
                        case 5: {
                            int i2;
                            if (rep >= 0 && rep <= 1) {
                                Object[] a = new Float[count];
                                for (i2 = 0; i2 < count; ++i2) {
                                    int definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        a[i2] = Float.valueOf(columnReader.getFloat());
                                    }
                                    columnReader.consume();
                                }
                                Intrinsics.checkNotNull((Object)name);
                                Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                            } else if (rep > 1) {
                                // empty if block
                            }
                            Unit unit = Unit.INSTANCE;
                            continue block66;
                        }
                        case 6: {
                            int i2;
                            if (rep >= 0 && rep <= 1) {
                                Object[] a = new Double[count];
                                for (i2 = 0; i2 < count; ++i2) {
                                    int definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        a[i2] = columnReader.getDouble();
                                    }
                                    columnReader.consume();
                                }
                                Intrinsics.checkNotNull((Object)name);
                                Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                            }
                            Unit unit = Unit.INSTANCE;
                            continue block66;
                        }
                        case 7: 
                        case 8: {
                            int scale;
                            DecimalMetadata decimalMetadata;
                            int definitionLevel;
                            int i;
                            Object[] a;
                            Unit unit;
                            OriginalType originalType4 = originalType;
                            switch (originalType4 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[originalType4.ordinal()]) {
                                case 11: {
                                    if (rep >= 0 && rep <= 1) {
                                        a = new String[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                a[i] = columnReader.getBinary().toStringUsingUTF8();
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    } else if (rep > 1) {
                                        throw new UnsupportedEncodingException("Unsuported repition level " + rep);
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                                case 6: {
                                    if (rep >= 0 && rep <= 1) {
                                        a = new BigDecimal[count];
                                        for (i = 0; i < count; ++i) {
                                            definitionLevel = columnReader.getCurrentDefinitionLevel();
                                            if (definitionLevel == maxDefinitionLevel) {
                                                byte[] value = columnReader.getBinary().getBytes();
                                                decimalMetadata = primitiveType.getDecimalMetadata();
                                                scale = decimalMetadata.getScale();
                                                a[i] = new BigDecimal(new BigInteger(value), scale);
                                            }
                                            columnReader.consume();
                                        }
                                        Intrinsics.checkNotNull((Object)name);
                                        Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                                    }
                                    unit = Unit.INSTANCE;
                                    continue block66;
                                }
                            }
                            if (rep >= 0 && rep <= 1) {
                                a = (Object[])new byte[count][];
                                for (i = 0; i < count; ++i) {
                                    definitionLevel = columnReader.getCurrentDefinitionLevel();
                                    if (definitionLevel == maxDefinitionLevel) {
                                        byte[] value = columnReader.getBinary().getBytes();
                                        decimalMetadata = primitiveType.getDecimalMetadata();
                                        scale = decimalMetadata.getScale();
                                        a[i] = columnReader.getBinary().getBytes();
                                    }
                                    columnReader.consume();
                                }
                                Intrinsics.checkNotNull((Object)name);
                                Intrinsics.checkNotNull((Object)SeriesFactory.Companion.create((Object)name, a), (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Int, kotlin.Any?>");
                            }
                            unit = Unit.INSTANCE;
                            continue block66;
                        }
                        default: {
                            System.err.println("Unsupported type " + primitiveType + ", " + originalType);
                            int r = 0;
                            while ((long)r < rowCount) {
                                columnReader.consume();
                                ++r;
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                }
                Series[] x = (Series[])ArraysKt.requireNoNulls((Object[])vectors);
                IndexedDataFrame dataFrame = new IndexedDataFrame(x);
                DataFrame dataFrame2 = (DataFrame)new DefaultDataFrame((DataFrame)dataFrame);
                return dataFrame2;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OriginalType.values().length];
            try {
                nArray[OriginalType.INT_8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.UINT_8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.INT_16.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.UINT_16.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.INT_32.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.DECIMAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.DATE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.TIME_MILLIS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.MAP.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.LIST.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.UTF8.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.MAP_KEY_VALUE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.ENUM.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.TIME_MICROS.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.TIMESTAMP_MILLIS.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.TIMESTAMP_MICROS.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.UINT_32.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.UINT_64.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.INT_64.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.JSON.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.BSON.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OriginalType.INTERVAL.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PrimitiveType.PrimitiveTypeName.values().length];
            try {
                nArray[PrimitiveType.PrimitiveTypeName.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.PrimitiveTypeName.INT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.PrimitiveTypeName.INT64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.PrimitiveTypeName.INT96.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.PrimitiveTypeName.FLOAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.PrimitiveTypeName.DOUBLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.PrimitiveTypeName.BINARY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

