/*
 * Decompiled with CFR 0.152.
 */
package org.molap.parquet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.OutputFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;
import org.molap.parquet.DataFrameParquetWriter;
import org.molap.parquet.ParquetOutputFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u0004B\u0019\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\t\u0010\fB\u001b\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000fJ \u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001dJ(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001dH\u0002J \u0010\u001f\u001a\u00020\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001dJ\u0006\u0010 \u001a\u00020\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lorg/molap/parquet/ParquetDataFrameExporter;", "R", "C", "V", "", "file", "Lorg/apache/parquet/io/OutputFile;", "compressionCodecName", "Lorg/apache/parquet/hadoop/metadata/CompressionCodecName;", "<init>", "(Lorg/apache/parquet/io/OutputFile;Lorg/apache/parquet/hadoop/metadata/CompressionCodecName;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;Lorg/apache/parquet/hadoop/metadata/CompressionCodecName;)V", "getFile", "()Lorg/apache/parquet/io/OutputFile;", "getCompressionCodecName", "()Lorg/apache/parquet/hadoop/metadata/CompressionCodecName;", "parquetWriter", "Lorg/apache/parquet/hadoop/ParquetWriter;", "getParquetWriter", "()Lorg/apache/parquet/hadoop/ParquetWriter;", "setParquetWriter", "(Lorg/apache/parquet/hadoop/ParquetWriter;)V", "exportParquet", "", "df", "Lorg/molap/dataframe/DataFrame;", "init", "write", "close", "molap-parquet"})
public final class ParquetDataFrameExporter<R, C, V> {
    @NotNull
    private final OutputFile file;
    @NotNull
    private final CompressionCodecName compressionCodecName;
    @Nullable
    private ParquetWriter<R> parquetWriter;

    public ParquetDataFrameExporter(@NotNull OutputFile file, @NotNull CompressionCodecName compressionCodecName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)compressionCodecName, (String)"compressionCodecName");
        this.file = file;
        this.compressionCodecName = compressionCodecName;
    }

    public /* synthetic */ ParquetDataFrameExporter(OutputFile outputFile, CompressionCodecName compressionCodecName, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            compressionCodecName = CompressionCodecName.SNAPPY;
        }
        this(outputFile, compressionCodecName);
    }

    @NotNull
    public final OutputFile getFile() {
        return this.file;
    }

    @NotNull
    public final CompressionCodecName getCompressionCodecName() {
        return this.compressionCodecName;
    }

    @Nullable
    public final ParquetWriter<R> getParquetWriter() {
        return this.parquetWriter;
    }

    public final void setParquetWriter(@Nullable ParquetWriter<R> parquetWriter) {
        this.parquetWriter = parquetWriter;
    }

    public ParquetDataFrameExporter(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        HadoopOutputFile hadoopOutputFile = HadoopOutputFile.fromPath((Path)new Path(file.toString()), (Configuration)new Configuration());
        Intrinsics.checkNotNullExpressionValue((Object)hadoopOutputFile, (String)"fromPath(...)");
        this((OutputFile)hadoopOutputFile, null, 2, null);
    }

    public ParquetDataFrameExporter(@NotNull OutputStream outputStream, @NotNull CompressionCodecName compressionCodecName) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)compressionCodecName, (String)"compressionCodecName");
        this(new ParquetOutputFile(outputStream), compressionCodecName);
    }

    public /* synthetic */ ParquetDataFrameExporter(OutputStream outputStream, CompressionCodecName compressionCodecName, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            compressionCodecName = CompressionCodecName.SNAPPY;
        }
        this(outputStream, compressionCodecName);
    }

    public final void exportParquet(@NotNull DataFrame<R, C, V> df) throws IOException {
        Intrinsics.checkNotNullParameter(df, (String)"df");
        this.write(df);
        this.close();
    }

    private final ParquetWriter<R> init(DataFrame<R, C, V> df) throws IOException {
        int pageSize = 65536;
        ParquetWriter parquetWriter = ((DataFrameParquetWriter.Builder)((DataFrameParquetWriter.Builder)((DataFrameParquetWriter.Builder)DataFrameParquetWriter.Companion.builder(this.file).withSchema(df).withCompressionCodec(this.compressionCodecName)).withPageSize(pageSize)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();
        Intrinsics.checkNotNull((Object)parquetWriter);
        return parquetWriter;
    }

    public final void write(@NotNull DataFrame<R, C, V> df) throws IOException {
        Intrinsics.checkNotNullParameter(df, (String)"df");
        if (this.parquetWriter == null) {
            this.parquetWriter = this.init(df);
        }
        for (Object row : df.rows()) {
            ParquetWriter<R> parquetWriter = this.parquetWriter;
            Intrinsics.checkNotNull(parquetWriter);
            parquetWriter.write(row);
        }
    }

    public final void close() throws IOException {
        ParquetWriter<R> parquetWriter = this.parquetWriter;
        Intrinsics.checkNotNull(parquetWriter);
        parquetWriter.close();
    }
}

