/*
 * Decompiled with CFR 0.152.
 */
package org.molap.parquet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/molap/parquet/ParquetStream;", "Lorg/apache/parquet/io/InputFile;", "streamId", "", "stream", "Ljava/io/ByteArrayOutputStream;", "<init>", "(Ljava/lang/String;Ljava/io/ByteArrayOutputStream;)V", "data", "", "getLength", "", "newStream", "Lorg/apache/parquet/io/SeekableInputStream;", "toString", "SeekableByteArrayInputStream", "molap-parquet"})
public final class ParquetStream
implements InputFile {
    @NotNull
    private final String streamId;
    @NotNull
    private final byte[] data;

    public ParquetStream(@NotNull String streamId, @NotNull ByteArrayOutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.streamId = streamId;
        byte[] byArray = stream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        this.data = byArray;
    }

    public long getLength() throws IOException {
        return this.data.length;
    }

    @NotNull
    public SeekableInputStream newStream() throws IOException {
        SeekableByteArrayInputStream seekableByteArrayInputStream = new SeekableByteArrayInputStream(this.data);
        return (SeekableInputStream)new DelegatingSeekableInputStream(seekableByteArrayInputStream){

            public void seek(long newPos) throws IOException {
                InputStream inputStream = this.getStream();
                Intrinsics.checkNotNull((Object)inputStream, (String)"null cannot be cast to non-null type org.molap.parquet.ParquetStream.SeekableByteArrayInputStream");
                ((SeekableByteArrayInputStream)inputStream).setPos((int)newPos);
            }

            public long getPos() throws IOException {
                InputStream inputStream = this.getStream();
                Intrinsics.checkNotNull((Object)inputStream, (String)"null cannot be cast to non-null type org.molap.parquet.ParquetStream.SeekableByteArrayInputStream");
                return ((SeekableByteArrayInputStream)inputStream).getPos();
            }
        };
    }

    @NotNull
    public String toString() {
        String string = "ParquetStream[" + this.streamId + "]";
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/molap/parquet/ParquetStream$SeekableByteArrayInputStream;", "Ljava/io/ByteArrayInputStream;", "buf", "", "<init>", "(Lorg/molap/parquet/ParquetStream;[B)V", "pos", "", "getPos", "()I", "setPos", "(I)V", "molap-parquet"})
    public final class SeekableByteArrayInputStream
    extends ByteArrayInputStream {
        public SeekableByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int pos) {
            this.pos = pos;
        }
    }
}

