/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.exporter.parquet

import org.apache.parquet.io.OutputFile
import java.io.IOException
import java.io.OutputStream

class ParquetOutputFile(private val outputStream: OutputStream?) : OutputFile {
    @Throws(IOException::class)
    override fun create(ignored: Long): PositionOutputStream {
        return PositionOutputStream(outputStream)
    }

    @Throws(IOException::class)
    override fun createOrOverwrite(ignored: Long): PositionOutputStream {
        return PositionOutputStream(outputStream)
    }

    override fun supportsBlockSize(): Boolean {
        return false
    }

    override fun defaultBlockSize(): Long {
        return 0
    }
}