package org.molap.postgresql

import org.jetbrains.exposed.sql.transactions.transaction
import org.molap.dataframe.DataFrame
import org.molap.db.jdbc.DatabaseDriverFactory
import org.molap.db.jdbc.JDBCDataFrame
import org.molap.db.jdbc.JDBCDatabaseDriver

fun DataFrame.Companion.readPostgreSQL(url : String, query : String, username : String? = null, password : String? = null): DataFrame<Int, String, Any?> {
    return JDBCDataFrame(DatabaseDriverFactory.get("PostGIS") as JDBCDatabaseDriver, url, query, username, password)
}

fun getTableColumns(tableName: String): List<String> {
    return transaction {
        val columns = mutableListOf<String>()

        connection.prepareStatement("SELECT * FROM $tableName LIMIT 1", false).let { statement ->
            val resultSet = statement.executeQuery()
            val metaData = resultSet.metaData
            for (i in 1..metaData.columnCount) {
                columns.add(metaData.getColumnName(i))
            }
        }

        columns
    }
}

fun queryTableDynamically(tableName: String): List<Map<String, Any?>> {
    return transaction {
        val columns = getTableColumns(tableName)
        val query = "SELECT * FROM $tableName"
        val result = mutableListOf<Map<String, Any?>>()

        exec(query) { rs ->
            while (rs.next()) {
                val row = columns.associateWith { column ->
                    rs.getObject(column)
                }
                result.add(row)
            }
        }
        result
    }
}
