package org.molap.postgresql.exposed

import org.jetbrains.exposed.sql.Database

fun Database.executeWithoutTransaction(sql: String) {
    // Get a raw JDBC connection from the Exposed Database
    connector().let { connection ->
        connection.autoCommit = true // Ensure auto-commit mode is enabled
        connection.prepareStatement(sql, false).executeUpdate()
    }
}