package org.molap.postgresql.exposed

import org.jetbrains.exposed.sql.*
import net.postgis.jdbc.geometry.Geometry
import net.postgis.jdbc.PGbox2d
import net.postgis.jdbc.PGgeometry
import net.postgis.jdbc.geometry.Point

/**
 * SELECT countries_cowid,st_astext(st_envelope(ST_Union(st_envelope(the_geom)))) FROM dbe.geocountryborders GROUP BY countries_cowid;
 * SELECT countries_cowid,ST_Extent(the_geom) FROM dbe.geocountryborders GROUP BY countries_cowid;
 * SELECT c.*,ST_Extent(the_geom) FROM dbe.countries c LEFT JOIN dbe.geocountryborders b ON c.gwid = b.countries_cowid GROUP BY c.gwid ORDER BY gwid;
 * SELECT c.*,ST_Extent(the_geom) FROM dbe.countries c LEFT JOIN dbe.geocountryborders b ON c.gwid = b.countries_cowid WHERE EXISTS (SELECT * FROM dbe.groups WHERE countries_cowid = c.gwid) GROUP BY c.gwid ORDER BY gwid;
 */
//class GeometryColumnType(val srid: Int = 4326) : ColumnType<Geometry>() {
//    override fun sqlType() = "GEOMETRY(Point, $srid)"
//    override fun valueFromDB(value: Any): Geometry? = if (value is PGgeometry) value.geometry else null
//    override fun notNullValueToDB(value: Geometry): Any {
//        if (value is Geometry) {
//            if (value.srid == Point.UNKNOWN_SRID) value.srid = srid
//            return PGgeometry(value)
//        }
//        return value
//    }
//}

class PointColumnType(val srid: Int = 4326) : ColumnType<Point>() {
    override fun sqlType() = "GEOMETRY(Point, $srid)"
    override fun valueFromDB(value: Any) = if (value is PGgeometry) value.geometry as Point else null
    override fun notNullValueToDB(value: Point): Any {
        if (value is Point) {
            if (value.srid == Point.UNKNOWN_SRID) value.srid = srid
            return PGgeometry(value)
        }
        return value
    }
}

class BoxColumnType(val srid: Int = 4326) : ColumnType<PGbox2d>() {
    override fun sqlType() = "BOX2D(Point, $srid)"
    override fun valueFromDB(value: Any) = if (value is PGbox2d) value else null
    override fun notNullValueToDB(value: PGbox2d): Any {
//        if (value is PGbox2d) {
//            if (value.srid == Point.UNKNOWN_SRID) value.srid = srid
//            return PGbox2d(value)
//        }
        return value
    }
}
//fun Table.geometry(name: String, srid: Int = 4326): Column<Geometry> =
//    registerColumn(name, GeometryColumnType(srid))

fun Table.point(name: String, srid: Int = 4326): Column<Point> =
    registerColumn(name, PointColumnType(srid))

/**
 * Special type to represent the box and if location of message
 * is inside the specified box
 */
class WithinOp(private val expr1: Expression<*>, private val box: PGbox2d) : Op<Boolean>() {
    override fun toQueryBuilder(queryBuilder: QueryBuilder) = queryBuilder { append("${expr1.toQueryBuilder(queryBuilder)} && ST_MakeEnvelope(${box.llb.x}, ${box.llb.y}, ${box.urt.x}, ${box.urt.y}, 4326)") }

}

class DistanceFunction(expr1: Expression<Point>, expr2: Expression<Point>) :
    CustomFunction<Double>("ST_DistanceSphere", DoubleColumnType(), expr1, expr2)

class ExtentFunction(expr1: Expression<Geometry>) :
    CustomFunction<PGbox2d>("ST_Extent", BoxColumnType(), expr1)

fun ExpressionWithColumnType<Geometry>.extent(): ExtentFunction = ExtentFunction(this)
