package org.molap.postgresql.exposed

import org.jetbrains.exposed.sql.Column
import org.jetbrains.exposed.sql.LongColumnType
import org.jetbrains.exposed.sql.ResultRow
import org.jetbrains.exposed.sql.Table
import kotlin.reflect.full.memberProperties
import kotlin.reflect.jvm.isAccessible

public fun Table.numeric(name: String): Column<Long> = registerColumn(name, LongColumnType())

fun ResultRow.toMap(): Map<String, Any?> {
    val mutableMap = mutableMapOf<String, Any?>()
    val dataList = this::class.memberProperties.find { it.name == "data" }?.apply {
        isAccessible = true
    }?.call(this) as Array<*>
    fieldIndex.entries.forEach { entry ->
        val column = entry.key as Column<*>
        val value = dataList[entry.value]
//        if(value != null) {
//            val cl = value::class
//            println("${dataList[entry.value]} ${cl}")
//        }
//        if(value is BigDecimal)
//            mutableMap[column.name] = value.toDouble()
//        else
//            mutableMap[column.name] = dataList[entry.value] as Any?
        mutableMap[column.name] = null
    }
    return mutableMap
}
