/*
 * Decompiled with CFR 0.152.
 */
package org.molap.postgresql;

import com.macrofocus.common.units.Quantity;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import kotlin.time.jdk8.InstantConversionsJDK8Kt;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.DateTimeArithmeticException;
import kotlinx.datetime.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ISqlExpressionBuilder;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinDateColumnTypeKt;
import org.jetbrains.exposed.sql.statements.DeleteStatement;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.molap.dataframe.DataFrame;
import org.molap.datetime.DateTimeTz;
import org.molap.postgresql.exposed.GeometryColumnTypeKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a>\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003\"\u0004\b\u0002\u0010\u0004*\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a>\u0010\n\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003\"\u0004\b\u0002\u0010\u0004*\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0006\u0010\u000b\u001a\u00020\u0007\u001aB\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003\"\u0004\b\u0002\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005\u001a:\u0010\u000f\u001a\u00020\r\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003\"\u0004\b\u0002\u0010\u00042\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\b\b\u0002\u0010\u0013\u001a\u00020\u0011\u001aB\u0010\u0014\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003\"\u0004\b\u0002\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005\u001aZ\u0010\u0016\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003\"\u0004\b\u0002\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019\u001a\u0012\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\u001aD\u0010#\u001a\u00020\r\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003\"\u0004\b\u0002\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005H\u0002\u001aD\u0010$\u001a\u00020\r\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003\"\u0004\b\u0002\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005H\u0002\"*\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0!j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"writePostgreSQL", "", "R", "C", "V", "Lorg/molap/dataframe/DataFrame;", "database", "Lorg/jetbrains/exposed/sql/Database;", "tableName", "", "appendPostgreSQL", "connectToDatabase", "createTableInDatabase", "Lorg/jetbrains/exposed/sql/Table;", "dataFrame", "createDynamicTable", "getTrailingFourDigitsOrDefault", "", "str", "default", "insertIntoDynamicTable", "dynamicTable", "replaceIntoDynamicTable", "column", "from", "Lorg/molap/datetime/DateTimeTz;", "to", "toLocalDateTime", "Lkotlinx/datetime/LocalDateTime;", "Lkotlin/time/Instant;", "timeZone", "Lkotlinx/datetime/TimeZone;", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "recreateTable", "getTable", "molap-postgresql"})
@SourceDebugExtension(value={"SMAP\nwritePostgreSQL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 writePostgreSQL.kt\norg/molap/postgresql/WritePostgreSQLKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n382#2,7:217\n382#2,7:224\n296#3,2:231\n298#3,2:234\n122#3,8:236\n296#3,4:244\n1#4:233\n*S KotlinDebug\n*F\n+ 1 writePostgreSQL.kt\norg/molap/postgresql/WritePostgreSQLKt\n*L\n185#1:217,7\n207#1:224,7\n121#1:231,2\n121#1:234,2\n148#1:236,8\n152#1:244,4\n*E\n"})
public final class WritePostgreSQLKt {
    @NotNull
    private static final HashMap<String, Table> map = new HashMap();

    public static final <R, C, V> void writePostgreSQL(@NotNull DataFrame<R, C, V> $this$writePostgreSQL, @NotNull Database database, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter($this$writePostgreSQL, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        try {
            Table table = WritePostgreSQLKt.recreateTable(database, tableName, $this$writePostgreSQL);
            WritePostgreSQLKt.insertIntoDynamicTable(database, table, $this$writePostgreSQL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final <R, C, V> void appendPostgreSQL(@NotNull DataFrame<R, C, V> $this$appendPostgreSQL, @NotNull Database database, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter($this$appendPostgreSQL, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Table table = WritePostgreSQLKt.getTable(database, tableName, $this$appendPostgreSQL);
        WritePostgreSQLKt.insertIntoDynamicTable(database, table, $this$appendPostgreSQL);
    }

    @NotNull
    public static final Database connectToDatabase() {
        return Database.Companion.connect$default((Database.Companion)Database.Companion, (String)"jdbc:postgresql_postGIS://localhost:5434/efluxdb", (String)"net.postgis.jdbc.DriverWrapperLW", (String)"postgres", (String)"zMLjmwMAlx4M056", null, null, null, null, (int)240, null);
    }

    @NotNull
    public static final <R, C, V> Table createTableInDatabase(@NotNull Database database, @NotNull String tableName, @NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Table dynamicTable = WritePostgreSQLKt.createDynamicTable(tableName, dataFrame);
        ThreadLocalTransactionManagerKt.transaction((Database)database, arg_0 -> WritePostgreSQLKt.createTableInDatabase$lambda$0(dynamicTable, arg_0));
        return dynamicTable;
    }

    @NotNull
    public static final <R, C, V> Table createDynamicTable(@NotNull String tableName, @NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        return new Table(dataFrame, tableName){
            {
                for (T column : $dataFrame.columns()) {
                    Column[] columnArray;
                    Column column2;
                    int srid;
                    Column column3;
                    String columnName;
                    KClass columnType = $dataFrame.getColumnClass(column);
                    Intrinsics.checkNotNull((Object)$dataFrame.getColumnName(column));
                    KClass kClass = columnType;
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                        column3 = Table.index$default((Table)this, (Column)this.nullable(Table.varchar$default((Table)this, (String)columnName, (int)255, null, (int)4, null)), null, (boolean)false, (int)3, null);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                        column3 = this.nullable(Table.integer$default((Table)this, (String)columnName, null, (int)2, null));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                        column3 = this.nullable(this.bool(columnName));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                        column3 = this.nullable(this.float(columnName));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                        column3 = this.nullable(this.double(columnName));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Quantity.class))) {
                        column3 = this.nullable(this.double(columnName));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(DateTimeTz.class))) {
                        column3 = Table.index$default((Table)this, (Column)this.nullable(KotlinDateColumnTypeKt.datetime((Table)this, (String)columnName)), null, (boolean)false, (int)3, null);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
                        column3 = Table.index$default((Table)this, (Column)this.nullable(KotlinDateColumnTypeKt.timestamp((Table)this, (String)columnName)), null, (boolean)false, (int)3, null);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class))) {
                        column3 = Table.index$default((Table)this, (Column)this.nullable(KotlinDateColumnTypeKt.timestamp((Table)this, (String)columnName)), null, (boolean)false, (int)3, null);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
                        column3 = this.nullable(this.binary(columnName));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Geometry.class))) {
                        srid = WritePostgreSQLKt.getTrailingFourDigitsOrDefault$default(columnName, 0, 2, null);
                        column2 = this.nullable(GeometryColumnTypeKt.geometry$default(this, columnName, null, srid, 2, null));
                        columnArray = new Column[]{column2};
                        Table.index$default((Table)this, null, (boolean)false, (Column[])columnArray, null, (String)"GIST", null, (int)40, null);
                        column3 = Unit.INSTANCE;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Point.class))) {
                        srid = WritePostgreSQLKt.getTrailingFourDigitsOrDefault$default(columnName, 0, 2, null);
                        column2 = this.nullable(GeometryColumnTypeKt.geometry$default(this, columnName, null, srid, 2, null));
                        columnArray = new Column[]{column2};
                        Table.index$default((Table)this, null, (boolean)false, (Column[])columnArray, null, (String)"GIST", null, (int)40, null);
                        column3 = Unit.INSTANCE;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(LineString.class))) {
                        srid = WritePostgreSQLKt.getTrailingFourDigitsOrDefault$default(columnName, 0, 2, null);
                        column2 = this.nullable(GeometryColumnTypeKt.geometry$default(this, columnName, null, srid, 2, null));
                        columnArray = new Column[]{column2};
                        Table.index$default((Table)this, null, (boolean)false, (Column[])columnArray, null, (String)"GIST", null, (int)40, null);
                        column3 = Unit.INSTANCE;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Polygon.class))) {
                        srid = WritePostgreSQLKt.getTrailingFourDigitsOrDefault$default(columnName, 0, 2, null);
                        column2 = this.nullable(GeometryColumnTypeKt.geometry$default(this, columnName, null, srid, 2, null));
                        columnArray = new Column[]{column2};
                        Table.index$default((Table)this, null, (boolean)false, (Column[])columnArray, null, (String)"GIST", null, (int)40, null);
                        column3 = Unit.INSTANCE;
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported column type: " + columnType + " for column " + columnName + " of table " + $tableName);
                }
            }
        };
    }

    public static final int getTrailingFourDigitsOrDefault(@NotNull String str, int n) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Object object = Regex.find$default((Regex)new Regex("(\\d{4})$"), (CharSequence)str, (int)0, (int)2, null);
        return object != null && (object = object.getValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : n;
    }

    public static /* synthetic */ int getTrailingFourDigitsOrDefault$default(String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 4326;
        }
        return WritePostgreSQLKt.getTrailingFourDigitsOrDefault(string, n);
    }

    public static final <R, C, V> void insertIntoDynamicTable(@NotNull Database database, @NotNull Table dynamicTable, @NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)dynamicTable, (String)"dynamicTable");
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        ThreadLocalTransactionManagerKt.transaction((Database)database, arg_0 -> WritePostgreSQLKt.insertIntoDynamicTable$lambda$0(dataFrame, dynamicTable, arg_0));
    }

    public static final <R, C, V> void replaceIntoDynamicTable(@NotNull Database database, @NotNull Table dynamicTable, @NotNull DataFrame<R, C, V> dataFrame, @NotNull String column, @NotNull DateTimeTz from, @NotNull DateTimeTz to) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)dynamicTable, (String)"dynamicTable");
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        ThreadLocalTransactionManagerKt.transaction((Database)database, arg_0 -> WritePostgreSQLKt.replaceIntoDynamicTable$lambda$0(dataFrame, dynamicTable, from, to, arg_0));
    }

    @NotNull
    public static final kotlinx.datetime.LocalDateTime toLocalDateTime(@NotNull Instant $this$toLocalDateTime, @NotNull TimeZone timeZone) {
        kotlinx.datetime.LocalDateTime localDateTime;
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        try {
            LocalDateTime localDateTime2 = LocalDateTime.ofInstant(InstantConversionsJDK8Kt.toJavaInstant((Instant)$this$toLocalDateTime), ConvertersKt.toJavaZoneId((TimeZone)timeZone));
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"ofInstant(...)");
            localDateTime = ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime2);
        }
        catch (DateTimeException e) {
            throw new DateTimeArithmeticException((Throwable)e);
        }
        return localDateTime;
    }

    /*
     * WARNING - void declaration
     */
    private static final <R, C, V> Table recreateTable(Database database, String tableName, DataFrame<R, C, V> dataFrame) {
        Object object;
        void $this$getOrPut$iv;
        Map map = WritePostgreSQLKt.map;
        String key$iv = tableName;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Table dynamicTable = WritePostgreSQLKt.createDynamicTable(tableName, dataFrame);
            ThreadLocalTransactionManagerKt.transaction((Database)database, arg_0 -> WritePostgreSQLKt.recreateTable$lambda$0$0(dynamicTable, arg_0));
            ThreadLocalTransactionManagerKt.transaction((Database)database, arg_0 -> WritePostgreSQLKt.recreateTable$lambda$0$1(dynamicTable, arg_0));
            ThreadLocalTransactionManagerKt.transaction((Database)database, arg_0 -> WritePostgreSQLKt.recreateTable$lambda$0$2(dynamicTable, arg_0));
            Table answer$iv = dynamicTable;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Table)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final <R, C, V> Table getTable(Database database, String tableName, DataFrame<R, C, V> dataFrame) {
        Object object;
        void $this$getOrPut$iv;
        Map map = WritePostgreSQLKt.map;
        String key$iv = tableName;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Table dynamicTable = WritePostgreSQLKt.createDynamicTable(tableName, dataFrame);
            ThreadLocalTransactionManagerKt.transaction((Database)database, arg_0 -> WritePostgreSQLKt.getTable$lambda$0$0(dynamicTable, arg_0));
            Table answer$iv = dynamicTable;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Table)object;
    }

    private static final Unit createTableInDatabase$lambda$0(Table $dynamicTable, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table[] tableArray = new Table[]{$dynamicTable};
        SchemaUtils.createMissingTablesAndColumns$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (boolean)false, (int)6, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit insertIntoDynamicTable$lambda$0(DataFrame $dataFrame, Table $dynamicTable, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        for (Object row : $dataFrame.rows()) {
            InsertStatement insertStatement;
            Table $this$insert$iv = $dynamicTable;
            boolean $i$f$insert = false;
            InsertStatement $this$insert_u24lambda_u243$iv = insertStatement = new InsertStatement($this$insert$iv, false, 2, null);
            boolean bl = false;
            InsertStatement insertStatement2 = $this$insert_u24lambda_u243$iv;
            Table $this$insertIntoDynamicTable_u24lambda_u240_u240 = $this$insert$iv;
            boolean bl2 = false;
            for (Object column : $dataFrame.columns()) {
                void it;
                Object v0;
                Object value;
                block8: {
                    value = $dataFrame.getValueAt(row, column);
                    if (value == null) continue;
                    Intrinsics.checkNotNull((Object)$dataFrame.getColumnName(column));
                    Iterable iterable = $dynamicTable.getColumns();
                    for (Object t : iterable) {
                        String columnName;
                        Column it2 = (Column)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it2.getName(), (Object)columnName)) continue;
                        v0 = t;
                        break block8;
                    }
                    v0 = null;
                }
                Intrinsics.checkNotNull(v0);
                Column dynamicColumn = v0;
                if (value instanceof Quantity) {
                    value = ((Quantity)value).getAmount();
                } else if (value instanceof DateTimeTz) {
                    value = WritePostgreSQLKt.toLocalDateTime(((DateTimeTz)value).getDatetime(), (TimeZone)TimeZone.Companion.getUTC());
                } else if (value instanceof LocalDateTime) {
                    java.time.Instant instant = ((LocalDateTime)value).toInstant(ZoneOffset.UTC);
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
                    value = InstantConversionsJDK8Kt.toKotlinInstant((java.time.Instant)instant);
                }
                it.set(dynamicColumn, value);
            }
            $this$insert_u24lambda_u243$iv.execute(TransactionManager.Companion.current());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit replaceIntoDynamicTable$lambda$0(DataFrame $dataFrame, Table $dynamicTable, DateTimeTz $from, DateTimeTz $to, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        for (Object row : $dataFrame.rows()) {
            Object v0;
            Column it;
            Object object;
            InsertStatement insertStatement;
            block9: {
                Iterable iterable = $dynamicTable.getColumns();
                insertStatement = iterable.iterator();
                while (insertStatement.hasNext()) {
                    object = insertStatement.next();
                    it = (Column)object;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"column")) continue;
                    v0 = object;
                    break block9;
                }
                v0 = null;
            }
            Intrinsics.checkNotNull(v0);
            Column column = v0;
            Table $this$deleteWhere_u24default$iv = $dynamicTable;
            Integer limit$iv = null;
            boolean $i$f$deleteWhere = false;
            object = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
            it = $this$deleteWhere_u24default$iv;
            Table table = $this$deleteWhere_u24default$iv;
            Transaction transaction = TransactionManager.Companion.current();
            DeleteStatement.Companion companion = DeleteStatement.Companion;
            boolean $i$a$-deleteWhere$default-WritePostgreSQLKt$replaceIntoDynamicTable$1$22 = false;
            Op op = (Op)SqlExpressionBuilder.INSTANCE.between((ExpressionWithColumnType)column, (Object)$from.getDatetime(), (Object)$to.getDatetime());
            companion.where(transaction, table, op, false, limit$iv);
            Table $this$insert$iv = $dynamicTable;
            boolean $i$f$insert = false;
            InsertStatement $this$insert_u24lambda_u243$iv = insertStatement = new InsertStatement($this$insert$iv, false, 2, null);
            boolean bl = false;
            InsertStatement $i$a$-deleteWhere$default-WritePostgreSQLKt$replaceIntoDynamicTable$1$22 = $this$insert_u24lambda_u243$iv;
            Table $this$replaceIntoDynamicTable_u24lambda_u240_u242 = $this$insert$iv;
            boolean bl2 = false;
            for (Object column2 : $dataFrame.columns()) {
                void it2;
                Object v1;
                Object value;
                block10: {
                    value = $dataFrame.getValueAt(row, column2);
                    if (value == null) continue;
                    Intrinsics.checkNotNull((Object)$dataFrame.getColumnName(column2));
                    Iterable iterable = $dynamicTable.getColumns();
                    for (Object t : iterable) {
                        String columnName;
                        Column it3 = (Column)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it3.getName(), (Object)columnName)) continue;
                        v1 = t;
                        break block10;
                    }
                    v1 = null;
                }
                Intrinsics.checkNotNull(v1);
                Column dynamicColumn = v1;
                if (value instanceof Quantity) {
                    value = ((Quantity)value).getAmount();
                } else if (value instanceof DateTimeTz) {
                    value = WritePostgreSQLKt.toLocalDateTime(((DateTimeTz)value).getDatetime(), (TimeZone)TimeZone.Companion.getUTC());
                } else if (value instanceof LocalDateTime) {
                    java.time.Instant instant = ((LocalDateTime)value).toInstant(ZoneOffset.UTC);
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
                    value = InstantConversionsJDK8Kt.toKotlinInstant((java.time.Instant)instant);
                }
                it2.set(dynamicColumn, value);
            }
            $this$insert_u24lambda_u243$iv.execute(TransactionManager.Companion.current());
        }
        return Unit.INSTANCE;
    }

    private static final Unit recreateTable$lambda$0$0(Table $dynamicTable, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table[] tableArray = new Table[]{$dynamicTable};
        SchemaUtils.drop$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit recreateTable$lambda$0$1(Table $dynamicTable, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table[] tableArray = new Table[]{$dynamicTable};
        SchemaUtils.create$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final int recreateTable$lambda$0$2(Table $dynamicTable, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        return QueriesKt.deleteAll((Table)$dynamicTable);
    }

    private static final Unit getTable$lambda$0$0(Table $dynamicTable, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table[] tableArray = new Table[]{$dynamicTable};
        SchemaUtils.createMissingTablesAndColumns$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (boolean)false, (int)6, null);
        return Unit.INSTANCE;
    }
}

