/*
 * Decompiled with CFR 0.152.
 */
package org.molap.postgresql.exposed;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.postgis.jdbc.PGgeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/molap/postgresql/exposed/GeometryColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/locationtech/jts/geom/Geometry;", "srid", "", "type", "", "<init>", "(ILjava/lang/String;)V", "getSrid", "()I", "getType", "()Ljava/lang/String;", "wktReader", "Lorg/locationtech/jts/io/WKTReader;", "wktWriter", "Lorg/locationtech/jts/io/WKTWriter;", "sqlType", "valueFromDB", "value", "", "valueToDB", "notNullValueToDB", "setParameter", "", "stmt", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "index", "molap-postgresql"})
public final class GeometryColumnType
extends ColumnType<Geometry> {
    private final int srid;
    @NotNull
    private final String type;
    @NotNull
    private final WKTReader wktReader;
    @NotNull
    private final WKTWriter wktWriter;

    public GeometryColumnType(int srid, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super(false, 1, null);
        this.srid = srid;
        this.type = type;
        this.wktReader = new WKTReader(null, 1, null);
        this.wktWriter = new WKTWriter(0, 1, null);
    }

    public /* synthetic */ GeometryColumnType(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4326;
        }
        this(n, string);
    }

    public final int getSrid() {
        return this.srid;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public String sqlType() {
        return "GEOMETRY(" + this.type + ", " + this.srid + ")";
    }

    @Nullable
    public Geometry valueFromDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Unexpected value: " + value);
        }
        return this.wktReader.read((String)value);
    }

    @Nullable
    public Object valueToDB(@Nullable Geometry value) {
        return value == null ? null : value;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Geometry value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = this.valueToDB(value);
        if (object == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        return object;
    }

    public void setParameter(@NotNull PreparedStatementApi stmt, int index, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        if (value == null) {
            stmt.setNull(index, (IColumnType)new GeometryColumnType(0, "Geometry", 1, null));
        } else if (value instanceof Geometry) {
            stmt.set(index, (Object)new PGgeometry(((Geometry)value).toText()));
        } else {
            stmt.set(index, value);
        }
    }
}

