/*
 * Decompiled with CFR 0.152.
 */
package org.molap.postgresql.exposed;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.postgis.jdbc.PGgeometry;
import net.postgis.jdbc.geometry.Geometry;
import net.postgis.jdbc.geometry.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/molap/postgresql/exposed/PointColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lnet/postgis/jdbc/geometry/Point;", "srid", "", "<init>", "(I)V", "getSrid", "()I", "sqlType", "", "valueFromDB", "value", "", "notNullValueToDB", "molap-postgresql"})
public final class PointColumnType
extends ColumnType<Point> {
    private final int srid;

    public PointColumnType(int srid) {
        super(false, 1, null);
        this.srid = srid;
    }

    public /* synthetic */ PointColumnType(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4326;
        }
        this(n);
    }

    public final int getSrid() {
        return this.srid;
    }

    @NotNull
    public String sqlType() {
        return "GEOMETRY(Point, " + this.srid + ")";
    }

    @Nullable
    public Point valueFromDB(@NotNull Object value) {
        Point point;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof PGgeometry) {
            Geometry geometry = ((PGgeometry)value).getGeometry();
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type net.postgis.jdbc.geometry.Point");
            point = (Point)geometry;
        } else {
            point = null;
        }
        return point;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Point value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value.srid == 0) {
            value.srid = this.srid;
        }
        return new PGgeometry((Geometry)value);
    }

    public PointColumnType() {
        this(0, 1, null);
    }
}

