package org.molap.questdb

import com.macrofocus.common.json.JsonObject
import korlibs.time.DateFormat
import korlibs.time.DateTime
import kotlinx.browser.window
import kotlinx.coroutines.Deferred
import kotlinx.coroutines.async
import kotlinx.coroutines.await
import kotlinx.coroutines.coroutineScope
import org.molap.dataframe.DataFrame
import org.molap.dataframe.JsonDataFrame

suspend fun loadJson(url: String): DataFrame<Int, String, Any?> {
    "Loading $url at ${
        DateTime.now().format(DateFormat.FORMAT2)
    }"
    val result = window.fetch(url).run {
        val json = await().text().await()
        val dataFrame = JsonDataFrame(json)
        println(
            "Loaded $url (${dataFrame.rowCount}x${dataFrame.columnCount}) at ${
                DateTime.now().format(DateFormat.FORMAT2)
            }"
        )
        dataFrame
    }

    return result
}

suspend fun loadQuestDB(url: String, dateTimeHandling : DateTimeHandling = DateTimeHandling.String): DataFrame<Int, String, Any?> {
    "Loading $url at ${
        DateTime.now().format(DateFormat.FORMAT2)
    }"
    val result = window.fetch(url).run {
        val json = await().json().await().unsafeCast<JsonObject>()
        val dataFrame = QuestDBDataFrame(json, dateTimeHandling)
        println(
            "Loaded $url (${dataFrame.rowCount}x${dataFrame.columnCount}) at ${
                DateTime.now().format(DateFormat.FORMAT2)
            }"
        )
        dataFrame
    }

    return result
}

suspend fun loadQuestDBAync(url: String): Deferred<DataFrame<Int, String, Any?>>  = coroutineScope {
    async { loadQuestDB(url) }
}