package org.molap.questdb

import com.macrofocus.common.json.JsonObject
import org.molap.dataframe.DataFrame

fun DataFrame.Companion.readQuestDBJson(json: String, dateTimeHanding: DateTimeHandling = DateTimeHandling.String, vararg geomColumns: String): DataFrame<Int, String, Any?> {
    return QuestDBDataFrame(json, dateTimeHanding, *geomColumns)
}

fun DataFrame.Companion.readQuestDBJson(json: JsonObject, dateTimeHanding: DateTimeHandling = DateTimeHandling.String, vararg geomColumns: String): DataFrame<Int, String, Any?> {
    return QuestDBDataFrame(json, dateTimeHanding, *geomColumns)
}