/*
 * Decompiled with CFR 0.152.
 */
package org.molap.questdb;

import com.macrofocus.common.units.Quantity;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.security.AllowAllSecurityContext;
import io.questdb.griffin.SqlCompilerImpl;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.std.Os;
import java.io.Closeable;
import korlibs.time.DateTime;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.molap.dataframe.DataFrame;
import org.molap.exporter.DataFrameExport;
import org.molap.questdb.CairoEngineKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J4\u0010\u0007\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u0017\"\u0004\b\u0001\u0010\u0018\"\u0004\b\u0002\u0010\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u001bH\u0002J4\u0010\u001c\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u0017\"\u0004\b\u0001\u0010\u0018\"\u0004\b\u0002\u0010\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u001bH\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lorg/molap/questdb/QuestDBDataFrameExport;", "Lorg/molap/exporter/DataFrameExport;", "engine", "Lio/questdb/cairo/CairoEngine;", "table", "", "lock", "initialize", "", "(Lio/questdb/cairo/CairoEngine;Ljava/lang/String;Ljava/lang/String;Z)V", "compiler", "Lio/questdb/griffin/SqlCompilerImpl;", "getCompiler", "()Lio/questdb/griffin/SqlCompilerImpl;", "ctx", "Lio/questdb/griffin/SqlExecutionContextImpl;", "getCtx", "()Lio/questdb/griffin/SqlExecutionContextImpl;", "initialized", "getTable", "()Ljava/lang/String;", "close", "", "R", "C", "V", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "write", "molap-questdb"})
public final class QuestDBDataFrameExport
implements DataFrameExport {
    @NotNull
    private final CairoEngine engine;
    @NotNull
    private final String table;
    @NotNull
    private final String lock;
    private final boolean initialize;
    private boolean initialized;
    @NotNull
    private final SqlExecutionContextImpl ctx;
    @NotNull
    private final SqlCompilerImpl compiler;

    public QuestDBDataFrameExport(@NotNull CairoEngine engine, @NotNull String table, @NotNull String lock, boolean initialize) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.engine = engine;
        this.table = table;
        this.lock = lock;
        this.initialize = initialize;
        this.initialized = !this.initialize;
        this.ctx = new SqlExecutionContextImpl(this.engine, 1);
        this.compiler = new SqlCompilerImpl(this.engine);
        this.ctx.with((SecurityContext)AllowAllSecurityContext.INSTANCE, null, null);
    }

    public /* synthetic */ QuestDBDataFrameExport(CairoEngine cairoEngine, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "lock";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(cairoEngine, string, string2, bl);
    }

    @NotNull
    public final String getTable() {
        return this.table;
    }

    @NotNull
    public final SqlExecutionContextImpl getCtx() {
        return this.ctx;
    }

    @NotNull
    public final SqlCompilerImpl getCompiler() {
        return this.compiler;
    }

    private final <R, C, V> void initialize(DataFrame<R, C, V> dataFrame) {
        StringBuilder sb = new StringBuilder("create table \"" + this.table + "\" (");
        boolean first = true;
        String timestamp = null;
        for (Object column : dataFrame.columns()) {
            String string;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            char c = '\"';
            Intrinsics.checkNotNull((Object)dataFrame.getColumnName(column));
            sb.append(c + string + "\"");
            sb.append(" ");
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                sb.append("double");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                sb.append("int");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                sb.append("boolean");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(DateTime.class))) {
                sb.append("timestamp");
                if (timestamp != null) continue;
                timestamp = dataFrame.getColumnName(column);
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                sb.append("symbol");
                continue;
            }
            sb.append("symbol");
        }
        sb.append(")");
        if (timestamp != null) {
            sb.append("timestamp(" + timestamp + ") PARTITION BY MONTH");
        }
        this.compiler.compile((CharSequence)sb.toString(), (SqlExecutionContext)this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <R, C, V> void write(@NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        if (!this.initialized) {
            if (CairoEngineKt.tableNotExists(this.engine, this.table)) {
                this.initialize(dataFrame);
            }
            this.initialized = true;
        }
        Object timestamp = null;
        for (Object column : dataFrame.columns()) {
            if (!Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(DateTime.class)) || timestamp != null) continue;
            timestamp = column;
        }
        TableToken tableToken = this.engine.getTableTokenIfExists((CharSequence)this.table);
        Closeable closeable = (Closeable)this.engine.getWriter(tableToken, "test");
        Throwable throwable = null;
        try {
            TableWriter writer = (TableWriter)closeable;
            boolean bl = false;
            for (Object r : dataFrame.rows()) {
                long l;
                if (timestamp != null) {
                    Object object = dataFrame.getValueAt(r, timestamp);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type korlibs.time.DateTime");
                    l = DateTime.getUnixMillisLong-impl((double)((DateTime)object).unbox-impl()) * (long)1000;
                } else {
                    l = Os.currentTimeMicros();
                }
                TableWriter.Row row = writer.newRow(l);
                for (Object column : dataFrame.columns()) {
                    int c = dataFrame.getColumnAddress(column);
                    Object v = dataFrame.getValueAt(r, column);
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                        if (v instanceof Double) {
                            row.putDouble(c, ((Number)v).doubleValue());
                            continue;
                        }
                        if (!(v instanceof Quantity)) continue;
                        row.putDouble(c, ((Quantity)v).getAmount());
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                        if (!(v instanceof Integer)) continue;
                        row.putInt(c, ((Number)v).intValue());
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                        if (!(v instanceof Boolean)) continue;
                        row.putBool(c, ((Boolean)v).booleanValue());
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(DateTime.class))) {
                        if (Intrinsics.areEqual(column, timestamp) || !(v instanceof DateTime)) continue;
                        row.putDate(c, DateTime.getUnixMillisLong-impl((double)((DateTime)v).unbox-impl()) * (long)1000);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                        if (v instanceof String) {
                            row.putSym(c, (CharSequence)v);
                            continue;
                        }
                        if (v == null) continue;
                        row.putSym(c, (CharSequence)v.toString());
                        continue;
                    }
                    if (v == null) continue;
                    row.putSym(c, (CharSequence)v.toString());
                }
                row.append();
            }
            long l = writer.commit();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void close() {
    }
}

