package org.molap.questdb

import io.questdb.cairo.CairoEngine
import io.questdb.cairo.CairoException
import io.questdb.cairo.security.AllowAllSecurityContext
import io.questdb.griffin.SqlCompilerImpl
import io.questdb.griffin.SqlException
import io.questdb.griffin.SqlExecutionContextImpl

fun CairoEngine.isTableEmpty(tableName: String) : Boolean {
    var empty = true
    val ctx = SqlExecutionContextImpl(this, 1)
    ctx.with(AllowAllSecurityContext.INSTANCE, null, null)
    try {
        SqlCompilerImpl(this).use { compiler ->
            compiler.compile('"' + tableName+ '"', ctx).recordCursorFactory.use { factory ->
                factory.getCursor(ctx).use { cursor ->
                    if (cursor.hasNext()) {
                        empty = false
                    }
                }
            }
        }
    } catch (e: CairoException) {
    } catch (e: SqlException) {
//        e.printStackTrace()
    } finally {
        ctx.close()
    }
    return empty
}

fun CairoEngine.tableNotExists(tableName: String) : Boolean {
    val x = getTableTokenIfExists(tableName)
    return x == null
}