package org.molap.questdb

import io.ktor.client.*
import io.ktor.client.request.*
import io.ktor.client.statement.*

object QuestDB {
    val httpdPort by lazy {
        System.getenv("QDB_HTTP_BIND_TO")?.substringAfter(":")?.toIntOrNull() ?: 9000
    }
}

public suspend fun query(
    query: String,
    client: HttpClient
): HttpResponse {
    val port = QuestDB.httpdPort
    val uri = "/exec"
    val response: HttpResponse = client.get("http://localhost:$port$uri") {
        parameter("query", query)
    }
    return response
}
