package org.molap.questdb

import com.macrofocus.common.file.readTextAndClose
import korlibs.time.DateFormat
import korlibs.time.DateTime
import kotlinx.coroutines.*
import org.molap.dataframe.DataFrame
import java.io.File
import java.io.InputStream

suspend fun loadQuestDB(file: File, dateTimeHandling : DateTimeHandling = DateTimeHandling.String): DataFrame<Int, String, Any?> {
    println("Loading $file at ${
        DateTime.now().format(DateFormat.FORMAT2)
    }")

    val dataFrame = loadQuestDB(file.inputStream(), dateTimeHandling)

    println(
        "Loaded $file (${dataFrame.rowCount}x${dataFrame.columnCount}) at ${
            DateTime.now().format(DateFormat.FORMAT2)
        }"
    )

    return dataFrame
}

suspend fun loadQuestDB(inputStream: InputStream, dateTimeHandling : DateTimeHandling = DateTimeHandling.String): DataFrame<Int, String, Any?> = withContext(Dispatchers.IO) {
    val dataFrame = QuestDBDataFrame(inputStream.readTextAndClose(), dateTimeHandling)

    dataFrame
}

suspend fun loadQuestDBAync(inputStream: InputStream): Deferred<DataFrame<Int, String, Any?>>  = coroutineScope {
    async { loadQuestDB(inputStream) }
}