/*
 * Decompiled with CFR 0.152.
 */
package org.molap.questdb;

import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonException;
import com.macrofocus.common.json.JsonFactory;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonType;
import com.macrofocus.common.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import korlibs.time.DateFormat;
import korlibs.time.DateFormatKt;
import korlibs.time.DateTime;
import korlibs.time.PatternDateFormat;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.io.WKTReader;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.IntegerRangeUniqueIndex;
import org.molap.index.UniqueIndex;
import org.molap.questdb.DateTimeHandling;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 (2\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001:\u0001(B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\n\"\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fB/\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\n\"\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\u0014\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0018\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00162\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R \u0010\u0015\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u00160\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010$\u001a\u0004\b&\u0010\"\u00a8\u0006)"}, d2={"Lorg/molap/questdb/QuestDBDataFrame;", "Lorg/molap/dataframe/AbstractDataFrame;", "", "", "", "root", "Lcom/macrofocus/common/json/JsonObject;", "dateTimeHanding", "Lorg/molap/questdb/DateTimeHandling;", "geomColumns", "", "<init>", "(Lcom/macrofocus/common/json/JsonObject;Lorg/molap/questdb/DateTimeHandling;[Ljava/lang/String;)V", "json", "(Ljava/lang/String;Lorg/molap/questdb/DateTimeHandling;[Ljava/lang/String;)V", "getRoot", "()Lcom/macrofocus/common/json/JsonObject;", "getDateTimeHanding", "()Lorg/molap/questdb/DateTimeHandling;", "labels", "[Ljava/lang/String;", "classes", "Lkotlin/reflect/KClass;", "[Lkotlin/reflect/KClass;", "array", "Lcom/macrofocus/common/json/JsonArray;", "getRowClass", "row", "getColumnClass", "column", "getValueAt", "rowIndex", "Lorg/molap/index/UniqueIndex;", "getRowIndex", "()Lorg/molap/index/UniqueIndex;", "rowIndex$delegate", "Lkotlin/Lazy;", "columnIndex", "getColumnIndex", "columnIndex$delegate", "Companion", "molap-questdb"})
public final class QuestDBDataFrame
extends AbstractDataFrame<Integer, String, Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonObject root;
    @NotNull
    private final DateTimeHandling dateTimeHanding;
    @NotNull
    private final String[] labels;
    @NotNull
    private final KClass<? extends Object>[] classes;
    @Nullable
    private final JsonArray array;
    @NotNull
    private final Lazy rowIndex$delegate;
    @NotNull
    private final Lazy columnIndex$delegate;
    @NotNull
    private static final Lazy<PatternDateFormat> dateFormat$delegate = LazyKt.lazy(QuestDBDataFrame::dateFormat_delegate$lambda$6);

    public QuestDBDataFrame(@NotNull JsonObject root, @NotNull DateTimeHandling dateTimeHanding, String ... geomColumns) {
        Object column;
        HashMap types;
        LinkedHashSet<String> columns;
        block23: {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)((Object)dateTimeHanding), (String)"dateTimeHanding");
            Intrinsics.checkNotNullParameter((Object)geomColumns, (String)"geomColumns");
            this.root = root;
            this.dateTimeHanding = dateTimeHanding;
            columns = new LinkedHashSet<String>();
            types = new HashMap();
            JsonArray jsonColumns = this.root.getArray("columns");
            if (jsonColumns == null) break block23;
            int n = jsonColumns.length();
            for (int i = 0; i < n; ++i) {
                KClass kClass;
                Map map;
                String name;
                block25: {
                    String type;
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        block31: {
                                            block30: {
                                                block29: {
                                                    block28: {
                                                        block27: {
                                                            block26: {
                                                                block24: {
                                                                    JsonObject jsonObject = column = jsonColumns.getObject(i);
                                                                    Intrinsics.checkNotNull((Object)(jsonObject != null ? jsonObject.getString("name") : null));
                                                                    name = name;
                                                                    String string = column.getString("type");
                                                                    Intrinsics.checkNotNull((Object)string);
                                                                    Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                                                                    columns.add(name);
                                                                    map = types;
                                                                    if (!Intrinsics.areEqual((Object)type, (Object)"boolean")) break block24;
                                                                    kClass = Reflection.getOrCreateKotlinClass(Boolean.TYPE);
                                                                    break block25;
                                                                }
                                                                if (!Intrinsics.areEqual((Object)type, (Object)"byte")) break block26;
                                                                kClass = Reflection.getOrCreateKotlinClass(Number.class);
                                                                break block25;
                                                            }
                                                            if (!Intrinsics.areEqual((Object)type, (Object)"short")) break block27;
                                                            kClass = Reflection.getOrCreateKotlinClass(Number.class);
                                                            break block25;
                                                        }
                                                        if (!Intrinsics.areEqual((Object)type, (Object)"char")) break block28;
                                                        kClass = Reflection.getOrCreateKotlinClass(String.class);
                                                        break block25;
                                                    }
                                                    if (!Intrinsics.areEqual((Object)type, (Object)"int")) break block29;
                                                    kClass = Reflection.getOrCreateKotlinClass(Integer.TYPE);
                                                    break block25;
                                                }
                                                if (!Intrinsics.areEqual((Object)type, (Object)"float")) break block30;
                                                kClass = Reflection.getOrCreateKotlinClass(Float.TYPE);
                                                break block25;
                                            }
                                            if (!Intrinsics.areEqual((Object)type, (Object)"symbol")) break block31;
                                            kClass = ArraysKt.contains((Object[])geomColumns, (Object)name) ? Reflection.getOrCreateKotlinClass(Geometry.class) : Reflection.getOrCreateKotlinClass(String.class);
                                            break block25;
                                        }
                                        if (!Intrinsics.areEqual((Object)type, (Object)"string")) break block32;
                                        kClass = ArraysKt.contains((Object[])geomColumns, (Object)name) ? Reflection.getOrCreateKotlinClass(Geometry.class) : Reflection.getOrCreateKotlinClass(String.class);
                                        break block25;
                                    }
                                    if (!Intrinsics.areEqual((Object)type, (Object)"varchar")) break block33;
                                    kClass = ArraysKt.contains((Object[])geomColumns, (Object)name) ? Reflection.getOrCreateKotlinClass(Geometry.class) : Reflection.getOrCreateKotlinClass(String.class);
                                    break block25;
                                }
                                if (!Intrinsics.areEqual((Object)type, (Object)"long")) break block34;
                                kClass = Reflection.getOrCreateKotlinClass(Long.TYPE);
                                break block25;
                            }
                            if (!Intrinsics.areEqual((Object)type, (Object)"date")) break block35;
                            switch (WhenMappings.$EnumSwitchMapping$0[this.dateTimeHanding.ordinal()]) {
                                case 1: {
                                    kClass = Reflection.getOrCreateKotlinClass(String.class);
                                    break block25;
                                }
                                case 2: {
                                    kClass = Reflection.getOrCreateKotlinClass(Long.TYPE);
                                    break block25;
                                }
                                case 3: {
                                    kClass = Reflection.getOrCreateKotlinClass(DateTime.class);
                                    break block25;
                                }
                                case 4: {
                                    kClass = Reflection.getOrCreateKotlinClass(Instant.class);
                                    break block25;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                        }
                        if (!Intrinsics.areEqual((Object)type, (Object)"timestamp")) break block36;
                        switch (WhenMappings.$EnumSwitchMapping$0[this.dateTimeHanding.ordinal()]) {
                            case 1: {
                                kClass = Reflection.getOrCreateKotlinClass(String.class);
                                break block25;
                            }
                            case 2: {
                                kClass = Reflection.getOrCreateKotlinClass(Long.TYPE);
                                break block25;
                            }
                            case 3: {
                                kClass = Reflection.getOrCreateKotlinClass(DateTime.class);
                                break block25;
                            }
                            case 4: {
                                kClass = Reflection.getOrCreateKotlinClass(Instant.class);
                                break block25;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    if (Intrinsics.areEqual((Object)type, (Object)"double")) {
                        kClass = Reflection.getOrCreateKotlinClass(Double.TYPE);
                    } else if (Intrinsics.areEqual((Object)type, (Object)"binary")) {
                        kClass = Reflection.getOrCreateKotlinClass(String.class);
                    } else if (Intrinsics.areEqual((Object)type, (Object)"long256")) {
                        kClass = Reflection.getOrCreateKotlinClass(Number.class);
                    } else if (StringsKt.startsWith$default((String)type, (String)"geohash", (boolean)false, (int)2, null)) {
                        kClass = Reflection.getOrCreateKotlinClass(String.class);
                    } else {
                        System.out.println((Object)("Unknown type: " + type + " for column " + name + ". Assuming Any::class."));
                        kClass = Reflection.getOrCreateKotlinClass(Object.class);
                    }
                }
                KClass kClass2 = kClass;
                map.put(name, kClass2);
            }
        }
        this.array = this.root.getArray("dataset");
        this.labels = new String[columns.size()];
        this.classes = new KClass[columns.size()];
        int index = 0;
        Iterator iterator = columns.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            column = (String)e;
            this.labels[index] = column;
            KClass type = (KClass)types.get(column);
            KClass kClass = type;
            if (kClass == null) {
                kClass = Reflection.getOrCreateKotlinClass(Object.class);
            }
            this.classes[index] = kClass;
            ++index;
        }
        this.rowIndex$delegate = LazyKt.lazy(() -> QuestDBDataFrame.rowIndex_delegate$lambda$0(this));
        this.columnIndex$delegate = LazyKt.lazy(() -> QuestDBDataFrame.columnIndex_delegate$lambda$1(this));
    }

    public /* synthetic */ QuestDBDataFrame(JsonObject jsonObject, DateTimeHandling dateTimeHandling, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dateTimeHandling = DateTimeHandling.String;
        }
        this(jsonObject, dateTimeHandling, stringArray);
    }

    @NotNull
    public final JsonObject getRoot() {
        return this.root;
    }

    @NotNull
    public final DateTimeHandling getDateTimeHanding() {
        return this.dateTimeHanding;
    }

    public QuestDBDataFrame(@NotNull String json2, @NotNull DateTimeHandling dateTimeHanding, String ... geomColumns) {
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)((Object)dateTimeHanding), (String)"dateTimeHanding");
        Intrinsics.checkNotNullParameter((Object)geomColumns, (String)"geomColumns");
        this((JsonObject)JsonFactory.INSTANCE.parse(json2), dateTimeHanding, Arrays.copyOf(geomColumns, geomColumns.length));
    }

    public /* synthetic */ QuestDBDataFrame(String string, DateTimeHandling dateTimeHandling, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dateTimeHandling = DateTimeHandling.String;
        }
        this(string, dateTimeHandling, stringArray);
    }

    @NotNull
    public KClass<?> getRowClass(int row) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @NotNull
    public KClass<? extends Object> getColumnClass(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        KClass<? extends Object> kClass = this.classes[this.getColumnIndex().getAddress((Object)column)];
        Intrinsics.checkNotNull(kClass);
        return kClass;
    }

    @Nullable
    public Object getValueAt(int row, @NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return this.getValueAt(this.getRowAddress(row), this.getColumnAddress(column));
    }

    @NotNull
    public UniqueIndex<Integer> getRowIndex() {
        Lazy lazy = this.rowIndex$delegate;
        return (UniqueIndex)lazy.getValue();
    }

    @NotNull
    public UniqueIndex<String> getColumnIndex() {
        Lazy lazy = this.columnIndex$delegate;
        return (UniqueIndex)lazy.getValue();
    }

    @Nullable
    public final Object getValueAt(int rowIndex, int columnIndex) {
        Object[] objectArray;
        try {
            Object object;
            JsonValue value;
            JsonArray jsonArray = this.array;
            JsonValue jsonValue = jsonArray != null && (jsonArray = jsonArray.getArray(rowIndex)) != null ? jsonArray.get(columnIndex) : (value = null);
            if (value != null) {
                if (value.getType() == JsonType.NULL) {
                    object = null;
                } else if (value.getType() == JsonType.ARRAY) {
                    JsonArray jsonArray2 = value.asJsonArray();
                    Intrinsics.checkNotNull((Object)jsonArray2);
                    JsonArray array = jsonArray2;
                    Object[] a = new Object[array.length()];
                    int n = array.length();
                    for (int i = 0; i < n; ++i) {
                        a[i] = array.get(i);
                    }
                    object = a;
                } else if (value.getType() == JsonType.BOOLEAN) {
                    object = Boolean.valueOf(value.asBoolean());
                } else if (value.getType() == JsonType.NUMBER) {
                    object = Intrinsics.areEqual(this.classes[columnIndex], (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? (Number)((int)value.asNumber()) : (Number)(Intrinsics.areEqual(this.classes[columnIndex], (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)) ? (Number)Float.valueOf((float)value.asNumber()) : (Number)(Intrinsics.areEqual(this.classes[columnIndex], (Object)Reflection.getOrCreateKotlinClass(Long.TYPE)) ? (Number)((long)value.asNumber()) : (Number)value.asNumber()));
                } else if (value.getType() == JsonType.STRING) {
                    if (Intrinsics.areEqual(this.classes[columnIndex], (Object)Reflection.getOrCreateKotlinClass(DateTime.class))) {
                        DateTime dateTime;
                        String string = value.asString();
                        if (string != null) {
                            String it = string;
                            boolean bl = false;
                            dateTime = DateTime.box-impl((double)DateFormatKt.parseUtc((DateFormat)Companion.getDateFormat(), (String)it));
                        } else {
                            dateTime = null;
                        }
                        object = (Comparable)dateTime;
                    } else if (Intrinsics.areEqual(this.classes[columnIndex], (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                        Long l;
                        String string = value.asString();
                        if (string != null) {
                            String it = string;
                            boolean bl = false;
                            l = DateTime.getUnixMillisLong-impl((double)DateFormatKt.parseUtc((DateFormat)Companion.getDateFormat(), (String)it));
                        } else {
                            l = null;
                        }
                        object = l;
                    } else if (Intrinsics.areEqual(this.classes[columnIndex], (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
                        Instant instant;
                        String string = value.asString();
                        if (string != null) {
                            String it = string;
                            boolean bl = false;
                            instant = Instant.Companion.fromEpochMilliseconds(DateTime.getUnixMillisLong-impl((double)DateFormatKt.parseUtc((DateFormat)Companion.getDateFormat(), (String)it)));
                        } else {
                            instant = null;
                        }
                        object = (Comparable)instant;
                    } else if (Intrinsics.areEqual(this.classes[columnIndex], (Object)Reflection.getOrCreateKotlinClass(Geometry.class))) {
                        Object object2;
                        String string = value.asString();
                        if (string != null) {
                            String it = string;
                            boolean bl = false;
                            Geometry geometry = new WKTReader(null, 1, null).read(it);
                            object2 = geometry instanceof LineString && ((LineString)geometry).getLength() == 0.0 ? null : geometry;
                        } else {
                            object2 = null;
                        }
                        object = (Comparable)object2;
                    } else {
                        object = (Comparable)((Object)value.asString());
                    }
                } else {
                    object = value;
                }
            } else {
                return null;
            }
            objectArray = object;
        }
        catch (JsonException e) {
            e.printStackTrace();
            objectArray = null;
        }
        return objectArray;
    }

    private static final IntegerRangeUniqueIndex rowIndex_delegate$lambda$0(QuestDBDataFrame this$0) {
        JsonArray jsonArray = this$0.array;
        return new IntegerRangeUniqueIndex(0, (jsonArray != null ? jsonArray.length() : 0) - 1);
    }

    private static final DefaultUniqueIndex columnIndex_delegate$lambda$1(QuestDBDataFrame this$0) {
        ArrayList<String> names = new ArrayList<String>(this$0.labels.length);
        for (String string : this$0.labels) {
            Intrinsics.checkNotNull((Object)string);
            names.add(string);
        }
        return new DefaultUniqueIndex((List)names);
    }

    private static final PatternDateFormat dateFormat_delegate$lambda$6() {
        return DateFormat.Companion.invoke("yyyy-MM-dd'T'HH:mm:ss.SSSSSz");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/molap/questdb/QuestDBDataFrame$Companion;", "", "<init>", "()V", "dateFormat", "Lkorlibs/time/DateFormat;", "getDateFormat", "()Lkorlibs/time/DateFormat;", "dateFormat$delegate", "Lkotlin/Lazy;", "molap-questdb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateFormat getDateFormat() {
            Lazy lazy = dateFormat$delegate;
            return (DateFormat)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DateTimeHandling.values().length];
            try {
                nArray[DateTimeHandling.String.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateTimeHandling.Long.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateTimeHandling.DateTime.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateTimeHandling.Instant.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

