package org.molap.questdb

import io.ktor.client.*
import io.ktor.client.statement.*
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.runBlocking
import org.molap.dataframe.DataFrame

fun DataFrame.Companion.readQuestDB(query: String, dateTimeHanding: DateTimeHandling = DateTimeHandling.String, vararg geomColumns: String): DataFrame<Int, String, Any?> {
    val client = HttpClient()

    val json = runBlocking(Dispatchers.IO) {
        val response: HttpResponse = query(query, client)

        val json: String = response.bodyAsText()
        json
    }

    return QuestDBDataFrame(json, dateTimeHanding, *geomColumns)
}
