package org.molap.questdb

import io.questdb.cairo.CairoEngine
import org.molap.dataframe.DataFrame

fun <R,C,V> DataFrame<R, C, V>.writeQuestDB(engine: CairoEngine, tableName: String) {
    val export = getQuestDBDataFrameExport(engine, tableName)
    export.truncate()
    export.write(this)
}

fun <R,C,V> DataFrame<R, C, V>.appendQuestDB(engine: CairoEngine, tableName: String) {
    val export = getQuestDBDataFrameExport(engine, tableName)
    export.write(this)
}

private val map = HashMap<String, QuestDBDataFrameExport>()

private fun getQuestDBDataFrameExport(engine: CairoEngine, tableName: String):
        QuestDBDataFrameExport {
    return map.getOrPut(tableName, { QuestDBDataFrameExport(engine, tableName) })
}