/*
 * Decompiled with CFR 0.152.
 */
package org.molap.questdb;

import com.macrofocus.common.units.Quantity;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.std.BinarySequence;
import io.questdb.std.Os;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import java.io.Closeable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Iterator;
import korlibs.time.DateTime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.time.Instant;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTWriter;
import org.molap.dataframe.DataFrame;
import org.molap.datetime.DateTimeTz;
import org.molap.exporter.DataFrameExport;
import org.molap.questdb.CairoEngineKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ4\u0010\u0007\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u0010\"\u0004\b\u0002\u0010\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u000eJ4\u0010\u0015\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u0010\"\u0004\b\u0002\u0010\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/molap/questdb/QuestDBDataFrameExport;", "Lorg/molap/exporter/DataFrameExport;", "engine", "Lio/questdb/cairo/CairoEngine;", "table", "", "lock", "initialize", "", "<init>", "(Lio/questdb/cairo/CairoEngine;Ljava/lang/String;Ljava/lang/String;Z)V", "getTable", "()Ljava/lang/String;", "initialized", "", "R", "C", "V", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "truncate", "write", "close", "molap-questdb"})
public final class QuestDBDataFrameExport
implements DataFrameExport {
    @NotNull
    private final CairoEngine engine;
    @NotNull
    private final String table;
    @NotNull
    private final String lock;
    private boolean initialized;

    public QuestDBDataFrameExport(@NotNull CairoEngine engine, @NotNull String table, @NotNull String lock, boolean initialize) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.engine = engine;
        this.table = table;
        this.lock = lock;
        this.initialized = !initialize;
    }

    public /* synthetic */ QuestDBDataFrameExport(CairoEngine cairoEngine, String string, String object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            object = string + "-lock";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(cairoEngine, string, (String)object, bl);
    }

    @NotNull
    public final String getTable() {
        return this.table;
    }

    private final <R, C, V> void initialize(DataFrame<R, C, V> dataFrame) {
        StringBuilder sb = new StringBuilder("create table \"" + this.table + "\" (");
        boolean first = true;
        String timestamp = null;
        for (Object column : dataFrame.columns()) {
            StringBuilder stringBuilder;
            String string;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            char c = '\"';
            Intrinsics.checkNotNull((Object)dataFrame.getColumnName(column));
            sb.append(c + string + "\"");
            sb.append(" ");
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                stringBuilder = sb.append("double");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Quantity.class))) {
                stringBuilder = sb.append("double");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                stringBuilder = sb.append("float");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                stringBuilder = sb.append("long");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                stringBuilder = sb.append("int");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                stringBuilder = sb.append("boolean");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(DateTime.class))) {
                sb.append("timestamp");
                if (timestamp == null) {
                    timestamp = dataFrame.getColumnName(column);
                }
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(DateTimeTz.class))) {
                sb.append("timestamp");
                if (timestamp == null) {
                    timestamp = dataFrame.getColumnName(column);
                }
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
                sb.append("timestamp");
                if (timestamp == null) {
                    timestamp = dataFrame.getColumnName(column);
                }
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(kotlinx.datetime.LocalDateTime.class))) {
                sb.append("timestamp");
                if (timestamp == null) {
                    timestamp = dataFrame.getColumnName(column);
                }
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class))) {
                sb.append("timestamp");
                if (timestamp == null) {
                    timestamp = dataFrame.getColumnName(column);
                }
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Timestamp.class))) {
                sb.append("timestamp");
                if (timestamp == null) {
                    timestamp = dataFrame.getColumnName(column);
                }
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
                stringBuilder = sb.append("binary");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Geometry.class))) {
                stringBuilder = sb.append("varchar");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Point.class))) {
                stringBuilder = sb.append("varchar");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(LineString.class))) {
                stringBuilder = sb.append("varchar");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Polygon.class))) {
                stringBuilder = sb.append("varchar");
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                stringBuilder = sb.append("symbol INDEX");
                continue;
            }
            System.out.println((Object)("Unknown column " + column + " with type " + dataFrame.getColumnClass(column)));
            stringBuilder = sb.append("varchar");
        }
        sb.append(")");
        if (timestamp != null) {
            sb.append("timestamp(" + timestamp + ") PARTITION BY WEEK");
        }
        sb.append(";");
        this.engine.execute((CharSequence)sb.toString());
    }

    public final void truncate() {
        if (!CairoEngineKt.tableNotExists(this.engine, this.table)) {
            this.engine.execute((CharSequence)("TRUNCATE TABLE " + this.table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized <R, C, V> void write(@NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        if (!this.initialized) {
            if (CairoEngineKt.tableNotExists(this.engine, this.table)) {
                this.initialize(dataFrame);
            }
            this.initialized = true;
        }
        Object timestamp = null;
        for (Object column : dataFrame.columns()) {
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(DateTime.class))) {
                if (timestamp != null) continue;
                timestamp = column;
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(DateTime.class))) {
                if (timestamp != null) continue;
                timestamp = column;
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(DateTimeTz.class))) {
                if (timestamp != null) continue;
                timestamp = column;
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
                if (timestamp != null) continue;
                timestamp = column;
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(kotlinx.datetime.LocalDateTime.class))) {
                if (timestamp != null) continue;
                timestamp = column;
                continue;
            }
            if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class))) {
                if (timestamp != null) continue;
                timestamp = column;
                continue;
            }
            if (!Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Timestamp.class)) || timestamp != null) continue;
            timestamp = column;
        }
        TableToken tableToken = this.engine.getTableTokenIfExists((CharSequence)this.table);
        Closeable closeable = (Closeable)this.engine.getWriter(tableToken, this.lock);
        Throwable throwable = null;
        try {
            TableWriter writer = (TableWriter)closeable;
            boolean bl = false;
            Iterator iterator = dataFrame.rows().iterator();
            while (true) {
                Iterator iterator2;
                TableWriter.Row row;
                Object r;
                block51: {
                    block46: {
                        long l;
                        block45: {
                            block47: {
                                Object value;
                                block50: {
                                    block49: {
                                        block48: {
                                            if (!iterator.hasNext()) break block46;
                                            r = iterator.next();
                                            if (timestamp == null) break block47;
                                            value = dataFrame.getValueAt(r, timestamp);
                                            if (!(value instanceof DateTime)) break block48;
                                            l = DateTime.getUnixMillisLong-impl((double)((DateTime)value).unbox-impl()) * (long)1000;
                                            break block45;
                                        }
                                        if (!(value instanceof DateTimeTz)) break block49;
                                        l = ((DateTimeTz)value).getDatetime().toEpochMilliseconds() * (long)1000;
                                        break block45;
                                    }
                                    if (!(value instanceof kotlinx.datetime.LocalDateTime)) break block50;
                                    l = TimeZoneKt.toInstant$default((kotlinx.datetime.LocalDateTime)((kotlinx.datetime.LocalDateTime)value), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()), null, (int)2, null).toEpochMilliseconds() * (long)1000;
                                    break block45;
                                }
                                if (value instanceof Instant) {
                                    l = ((Instant)value).toEpochMilliseconds() * (long)1000;
                                    break block45;
                                } else if (value instanceof LocalDateTime) {
                                    l = ((LocalDateTime)value).toInstant(ZoneOffset.UTC).toEpochMilli() * (long)1000;
                                    break block45;
                                } else {
                                    if (!(value instanceof Timestamp)) {
                                        Object object = value;
                                        Intrinsics.checkNotNull((Object)object);
                                        throw new UnsupportedOperationException("Unsupported value type: " + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName());
                                    }
                                    l = ((Timestamp)value).getTime() * (long)1000;
                                }
                                break block45;
                            }
                            l = Os.currentTimeMicros();
                        }
                        row = writer.newRow(l);
                        iterator2 = dataFrame.columns().iterator();
                        break block51;
                    }
                    writer.commit();
                    Unit unit = Unit.INSTANCE;
                    return;
                }
                while (iterator2.hasNext()) {
                    Object column = iterator2.next();
                    int c = dataFrame.getColumnAddress(column);
                    Object v = dataFrame.getValueAt(r, column);
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                        if (v instanceof Double) {
                            row.putDouble(c, ((Number)v).doubleValue());
                            continue;
                        }
                        if (!(v instanceof Quantity)) continue;
                        row.putDouble(c, ((Quantity)v).getAmount());
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Quantity.class))) {
                        if (v instanceof Double) {
                            row.putDouble(c, ((Number)v).doubleValue());
                            continue;
                        }
                        if (!(v instanceof Quantity)) continue;
                        row.putDouble(c, ((Quantity)v).getAmount());
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                        if (v instanceof Float) {
                            row.putFloat(c, ((Number)v).floatValue());
                            continue;
                        }
                        if (!(v instanceof Quantity)) continue;
                        row.putFloat(c, (float)((Quantity)v).getAmount());
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                        if (!(v instanceof Long)) continue;
                        row.putLong(c, ((Number)v).longValue());
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                        if (!(v instanceof Integer)) continue;
                        row.putInt(c, ((Number)v).intValue());
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                        if (!(v instanceof Boolean)) continue;
                        row.putBool(c, ((Boolean)v).booleanValue());
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(DateTimeTz.class))) {
                        if (Intrinsics.areEqual(column, timestamp) || !(v instanceof DateTimeTz)) continue;
                        row.putDate(c, ((DateTimeTz)v).getDatetime().toEpochMilliseconds() * (long)1000);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
                        if (Intrinsics.areEqual(column, timestamp) || !(v instanceof Instant)) continue;
                        row.putDate(c, ((Instant)v).toEpochMilliseconds() * (long)1000);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class))) {
                        if (Intrinsics.areEqual(column, timestamp) || !(v instanceof LocalDateTime)) continue;
                        row.putDate(c, ((LocalDateTime)v).toInstant(ZoneOffset.UTC).toEpochMilli() * (long)1000);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(DateTime.class))) {
                        if (Intrinsics.areEqual(column, timestamp) || !(v instanceof DateTime)) continue;
                        row.putDate(c, DateTime.getUnixMillisLong-impl((double)((DateTime)v).unbox-impl()) * (long)1000);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Timestamp.class))) {
                        if (Intrinsics.areEqual(column, timestamp) || !(v instanceof Timestamp)) continue;
                        row.putDate(c, ((Timestamp)v).getTime() * (long)1000);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
                        if (!(v instanceof byte[])) continue;
                        BinarySequence binarySequence2 = new BinarySequence(v){
                            final /* synthetic */ V $v;
                            {
                                this.$v = $v;
                            }

                            public long length() {
                                return ((byte[])this.$v).length;
                            }

                            public byte byteAt(long index) {
                                return ((byte[])this.$v)[(int)index];
                            }
                        };
                        row.putBin(c, binarySequence2);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Geometry.class))) {
                        if (!(v instanceof Geometry)) continue;
                        row.putVarchar(c, (Utf8Sequence)new Utf8String(new WKTWriter(0, 1, null).write((Geometry)v)));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Point.class))) {
                        if (!(v instanceof Point)) continue;
                        row.putVarchar(c, (Utf8Sequence)new Utf8String(new WKTWriter(0, 1, null).write((Geometry)v)));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(LineString.class))) {
                        if (!(v instanceof LineString)) continue;
                        row.putVarchar(c, (Utf8Sequence)new Utf8String(new WKTWriter(0, 1, null).write((Geometry)v)));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(Polygon.class))) {
                        if (!(v instanceof Polygon)) continue;
                        row.putVarchar(c, (Utf8Sequence)new Utf8String(new WKTWriter(0, 1, null).write((Geometry)v)));
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)dataFrame.getColumnClass(column), (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                        if (v instanceof String) {
                            try {
                                row.putSym(c, (CharSequence)v);
                            }
                            catch (NullPointerException e) {
                                System.out.println((Object)("Cannot write value " + v + " to column " + column + " into table " + this.table + " for row " + row + " because of " + e.getMessage()));
                            }
                            catch (UnsupportedOperationException e) {
                                System.out.println((Object)("Cannot write value " + v + " to column " + column + " into table " + this.table + " for row " + row + " because of " + e.getMessage()));
                            }
                            continue;
                        }
                        if (v == null) continue;
                        row.putSym(c, (CharSequence)v.toString());
                        continue;
                    }
                    if (v == null) continue;
                    System.out.println((Object)("Unknown type " + Reflection.getOrCreateKotlinClass(v.getClass()) + "  for value " + v + " in column " + column + " of table " + this.table + "... trying anyway"));
                    row.putSym(c, (CharSequence)v.toString());
                }
                row.append();
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void close() {
    }
}

