package org.molap.dataframe.xdataframe

import org.jetbrains.kotlinx.dataframe.AnyFrame
import org.jetbrains.kotlinx.dataframe.api.dataFrameOf
import org.jetbrains.kotlinx.dataframe.api.inferType
import org.molap.dataframe.AbstractDataFrame
import org.molap.dataframe.DataFrame
import org.molap.index.DefaultUniqueIndex
import org.molap.index.IntegerRangeUniqueIndex
import org.molap.index.UniqueIndex
import kotlin.reflect.KClass

class DataFrameDataFrame(private val df: AnyFrame) : AbstractDataFrame<Int, String, Any?>() {
    override val rowIndex: UniqueIndex<Int> by lazy { IntegerRangeUniqueIndex(0, df.rowsCount() - 1) }
    override val columnIndex: UniqueIndex<String> by lazy {
        val columnNames: Iterable<String> = df.columnNames()
        DefaultUniqueIndex<String>(columnNames, false)
    }

    override fun getRowClass(row: Int): KClass<*>? {
        TODO("Not yet implemented")
    }

    override fun getColumnClass(column: String): KClass<out Any> {
        return df.columnTypes()[columnIndex.getAddress(column)].classifier!! as KClass<out Any>
    }

    override fun getValueAt(row: Int, column: String): Any? {
        return df[row][column]
    }
}

fun AnyFrame.toDataFrame(): DataFrame<Int, String, Any?> {
    return DataFrameDataFrame(this)
}

fun <R,String,V> DataFrame<R, String, in V>.toAnyFrame(): AnyFrame {
    val anyFrame: AnyFrame = dataFrameOf(this.columnIndex.keys().map { it }) {
        val series = this.getColumn(it)
        series!!.keys()!!.map { series.get(it) }
    }
    return anyFrame.inferType()
}